/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.slf4j.MDC;
import spectator-agent.slf4j.Marker;
import spectator-agent.slf4j.MarkerFactory;
import spectator-agent.slf4j.event.Level;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Utils;
import spectator-agent.spectator.api.patterns.CardinalityLimiters;
import spectator-agent.spectator.ipc.IpcLogEntry;

public class IpcLogger {
    private static final Marker CLIENT = MarkerFactory.getMarker("ipc-client");
    private static final Marker SERVER = MarkerFactory.getMarker("ipc-server");
    private final Registry registry;
    private final Clock clock;
    private final Logger logger;
    private final ConcurrentHashMap<Id, AtomicInteger> inflightRequests;
    private final ConcurrentHashMap<String, Function<String, String>> limiters;
    private final LinkedBlockingQueue<IpcLogEntry> entries;

    IpcLogger(Registry registry, Clock clock, Logger logger) {
        this.registry = registry;
        this.clock = clock;
        this.logger = logger;
        this.inflightRequests = new ConcurrentHashMap();
        this.limiters = new ConcurrentHashMap();
        this.entries = new LinkedBlockingQueue(1000);
    }

    public IpcLogger(Registry registry, Logger logger) {
        this(registry, registry.clock(), logger);
    }

    public IpcLogger(Registry registry) {
        this(registry, registry.clock(), LoggerFactory.getLogger(IpcLogger.class));
    }

    AtomicInteger inflightRequests(Id id) {
        return Utils.computeIfAbsent(this.inflightRequests, id, i -> new AtomicInteger());
    }

    Function<String, String> limiterForKey(String key) {
        return Utils.computeIfAbsent(this.limiters, key, k -> CardinalityLimiters.rollup(25));
    }

    private IpcLogEntry newEntry() {
        IpcLogEntry entry = this.entries.poll();
        return entry == null ? new IpcLogEntry(this.clock) : entry;
    }

    public IpcLogEntry createClientEntry() {
        return this.newEntry().withRegistry(this.registry).withLogger(this).withMarker(CLIENT);
    }

    public IpcLogEntry createServerEntry() {
        return this.newEntry().withRegistry(this.registry).withLogger(this).withMarker(SERVER);
    }

    void log(IpcLogEntry entry) {
        BiConsumer<Marker, String> log;
        Predicate<Marker> enabled;
        Level level = entry.getLevel();
        switch (level) {
            case TRACE: {
                enabled = this.logger::isTraceEnabled;
                log = this.logger::trace;
                break;
            }
            case DEBUG: {
                enabled = this.logger::isDebugEnabled;
                log = this.logger::debug;
                break;
            }
            case INFO: {
                enabled = this.logger::isInfoEnabled;
                log = this.logger::info;
                break;
            }
            case WARN: {
                enabled = this.logger::isWarnEnabled;
                log = this.logger::warn;
                break;
            }
            case ERROR: {
                enabled = this.logger::isErrorEnabled;
                log = this.logger::error;
                break;
            }
            default: {
                enabled = this.logger::isDebugEnabled;
                log = this.logger::debug;
            }
        }
        if (enabled.test(entry.getMarker())) {
            entry.populateMDC();
            log.accept(entry.getMarker(), entry.toString());
            MDC.clear();
        }
        if (entry.isSuccessful()) {
            entry.reset();
            this.entries.offer(entry);
        } else {
            entry.resetForRetry();
        }
    }
}

