/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import spectator-agent.spectator.impl.matcher.Matcher;
import spectator-agent.spectator.impl.matcher.TrueMatcher;

final class SeqMatcher
implements Matcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Matcher[] matchers;
    private final int minLength;

    static Matcher create(List<Matcher> matchers) {
        return SeqMatcher.create(matchers.toArray(new Matcher[0]));
    }

    static Matcher create(Matcher ... matchers) {
        switch (matchers.length) {
            case 0: {
                return TrueMatcher.INSTANCE;
            }
            case 1: {
                return matchers[0];
            }
        }
        return new SeqMatcher(matchers);
    }

    private SeqMatcher(Matcher ... matchers) {
        this.matchers = matchers;
        int min = 0;
        for (Matcher matcher : matchers) {
            min += matcher.minLength();
        }
        this.minLength = min;
    }

    List<Matcher> matchers() {
        return Arrays.asList(this.matchers);
    }

    @Override
    public int matches(String str, int start, int length) {
        int end = start + length;
        int pos = start;
        for (int i = 0; i < this.matchers.length && pos >= 0; ++i) {
            pos = this.matchers[i].matches(str, pos, end - pos);
        }
        return pos;
    }

    @Override
    public String prefix() {
        return this.matchers[0].prefix();
    }

    @Override
    public String containedString() {
        Matcher m;
        String str = null;
        Matcher[] matcherArray = this.matchers;
        int n = matcherArray.length;
        for (int i = 0; i < n && (str = (m = matcherArray[i]).containedString()) == null; ++i) {
        }
        return str;
    }

    @Override
    public SortedSet<String> trigrams() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Matcher m : this.matchers) {
            ts.addAll(m.trigrams());
        }
        return ts;
    }

    @Override
    public int minLength() {
        return this.minLength;
    }

    @Override
    public boolean isStartAnchored() {
        return this.matchers[0].isStartAnchored();
    }

    @Override
    public boolean isEndAnchored() {
        return this.matchers[this.matchers.length - 1].isEndAnchored();
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        int n = this.matchers.length;
        Matcher[] ms = new Matcher[n];
        for (int i = 0; i < n; ++i) {
            ms[i] = this.matchers[i].rewrite(f);
        }
        return f.apply(SeqMatcher.create(ms));
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        int n = this.matchers.length;
        Matcher[] ms = new Matcher[n];
        System.arraycopy(this.matchers, 0, ms, 0, n - 1);
        ms[n - 1] = this.matchers[n - 1].rewriteEnd(f);
        return f.apply(SeqMatcher.create(ms));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Matcher m : this.matchers) {
            builder.append(m.toString());
        }
        builder.append(')');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeqMatcher that = (SeqMatcher)o;
        return this.minLength == that.minLength && Arrays.equals(this.matchers, that.matchers);
    }

    public int hashCode() {
        int result = this.minLength;
        result = 31 * result + Arrays.hashCode(this.matchers);
        return result;
    }
}

