/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc.http;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import spectator-agent.spectator.impl.AsciiSet;

public final class HostSanitizer {
    private static final int MAX_LENGTH = 120;
    private static final int MAX_SEGMENTS = 4;
    private static final AsciiSet ALPHA_CHARS = AsciiSet.fromPattern("a-zA-Z");
    private static final AsciiSet DIGITS = AsciiSet.fromPattern("0-9");
    private static final AsciiSet CONSONANTS = AsciiSet.fromPattern("b-df-hj-np-tv-xzB-DF-HJ-NP-TV-XZ");
    private static final Set<String> ALLOWED = new HashSet<String>();

    private HostSanitizer() {
    }

    public static String sanitize(String host) {
        return HostSanitizer.sanitize(host, Collections.emptySet());
    }

    public static String sanitize(String host, Set<String> allowed) {
        String tmp = HostSanitizer.sanitizeSegments(HostSanitizer.removePort(host), allowed);
        return tmp.isEmpty() ? "none" : tmp;
    }

    private static String removePort(String host) {
        int pos = host.lastIndexOf(58);
        return pos >= 0 ? host.substring(0, pos) : host;
    }

    private static String sanitizeSegments(String host, Set<String> allowed) {
        String segment;
        HostStringBuilder builder = new HostStringBuilder();
        int last = host.length();
        int pos = host.lastIndexOf(46);
        while (pos >= 0) {
            segment = host.substring(pos + 1, last);
            last = pos;
            pos = host.lastIndexOf(46, last - 1);
            if (segment.isEmpty()) continue;
            if (HostSanitizer.shouldSuppressSegment(segment, allowed)) {
                segment = "_";
            }
            if (builder.prepend(segment)) continue;
            break;
        }
        if (pos == -1 && !(segment = host.substring(0, last)).isEmpty()) {
            if (HostSanitizer.shouldSuppressSegment(segment, allowed)) {
                segment = "_";
            }
            builder.prepend(segment);
        }
        return builder.toString();
    }

    private static boolean shouldSuppressSegment(String segment, Set<String> allowed) {
        if (ALLOWED.contains(segment) || allowed.contains(segment)) {
            return false;
        }
        int maxSequentialConsonants = 4;
        int sequentialConsonants = 0;
        boolean version = false;
        boolean allAlpha = true;
        int n = segment.length();
        for (int i = 0; i < n; ++i) {
            char c = segment.charAt(i);
            if (CONSONANTS.contains(c)) {
                if (++sequentialConsonants >= 4) {
                    return true;
                }
            } else {
                sequentialConsonants = 0;
            }
            version = i == 0 && c == 'v' ? true : (version &= DIGITS.contains(c));
            if (version || (allAlpha &= ALPHA_CHARS.contains(c))) continue;
            return true;
        }
        return false;
    }

    static {
        ALLOWED.add("dbms");
        ALLOWED.add("ftlbknd");
        ALLOWED.add("graphql");
        ALLOWED.add("http");
        ALLOWED.add("http1");
        ALLOWED.add("http2");
        ALLOWED.add("mtls");
        ALLOWED.add("nccp");
        ALLOWED.add("nflx");
        ALLOWED.add("nrdp");
        ALLOWED.add("nrdpv6");
        ALLOWED.add("www2");
        ALLOWED.add("af-south-1");
        ALLOWED.add("ap-east-1");
        ALLOWED.add("ap-northeast-1");
        ALLOWED.add("ap-northeast-2");
        ALLOWED.add("ap-northeast-3");
        ALLOWED.add("ap-south-1");
        ALLOWED.add("ap-south-2");
        ALLOWED.add("ap-southeast-1");
        ALLOWED.add("ap-southeast-2");
        ALLOWED.add("ap-southeast-3");
        ALLOWED.add("ap-southeast-4");
        ALLOWED.add("ca-central-1");
        ALLOWED.add("ca-west-1");
        ALLOWED.add("eu-central-1");
        ALLOWED.add("eu-central-2");
        ALLOWED.add("eu-north-1");
        ALLOWED.add("eu-south-1");
        ALLOWED.add("eu-south-2");
        ALLOWED.add("eu-west-1");
        ALLOWED.add("eu-west-2");
        ALLOWED.add("eu-west-3");
        ALLOWED.add("fips.ca-central-1");
        ALLOWED.add("fips.ca-west-1");
        ALLOWED.add("fips.us-east-1");
        ALLOWED.add("fips.us-east-2");
        ALLOWED.add("fips.us-west-1");
        ALLOWED.add("fips.us-west-2");
        ALLOWED.add("il-central-1");
        ALLOWED.add("me-central-1");
        ALLOWED.add("me-south-1");
        ALLOWED.add("sa-east-1");
        ALLOWED.add("us-east-1");
        ALLOWED.add("us-east-2");
        ALLOWED.add("us-gov-east-1");
        ALLOWED.add("us-gov-west-1");
        ALLOWED.add("us-west-1");
        ALLOWED.add("us-west-2");
    }

    private static class HostStringBuilder {
        private final Deque<String> segments = new ArrayDeque<String>();
        private int length = 0;
        private boolean lastSuppressed = false;

        HostStringBuilder() {
        }

        boolean prepend(String segment) {
            if (this.segments.size() < 4 && segment.length() < 120 - this.length - 1) {
                boolean suppressed = "_".equals(segment);
                if (!this.lastSuppressed || !suppressed) {
                    this.lastSuppressed = suppressed;
                    this.segments.offer(segment);
                    this.length += this.segments.isEmpty() ? segment.length() : segment.length() + 1;
                }
                return true;
            }
            if (!this.lastSuppressed) {
                this.segments.offer("_");
            }
            this.lastSuppressed = true;
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.length);
            if (!this.segments.isEmpty()) {
                builder.append(this.segments.pollLast());
            }
            while (!this.segments.isEmpty()) {
                builder.append('.').append(this.segments.pollLast());
            }
            return builder.toString();
        }
    }
}

