/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicDouble
extends Number {
    private final AtomicLong value;

    public AtomicDouble() {
        this(0.0);
    }

    public AtomicDouble(double init) {
        this.value = new AtomicLong(Double.doubleToLongBits(init));
    }

    public double get() {
        return Double.longBitsToDouble(this.value.get());
    }

    public double addAndGet(double amount) {
        double d;
        double n;
        long next;
        long v;
        while (!this.value.compareAndSet(v = this.value.get(), next = Double.doubleToLongBits(n = (d = Double.longBitsToDouble(v)) + amount))) {
        }
        return n;
    }

    public double getAndAdd(double amount) {
        double d;
        double n;
        long next;
        long v;
        while (!this.value.compareAndSet(v = this.value.get(), next = Double.doubleToLongBits(n = (d = Double.longBitsToDouble(v)) + amount))) {
        }
        return d;
    }

    public double getAndSet(double amount) {
        long v = this.value.getAndSet(Double.doubleToLongBits(amount));
        return Double.longBitsToDouble(v);
    }

    public boolean compareAndSet(double expect, double update) {
        long e = Double.doubleToLongBits(expect);
        long u = Double.doubleToLongBits(update);
        return this.value.compareAndSet(e, u);
    }

    public void set(double amount) {
        this.value.set(Double.doubleToLongBits(amount));
    }

    private boolean isGreaterThan(double v1, double v2) {
        return v1 > v2 || Double.isNaN(v2);
    }

    public void max(double v) {
        if (Double.isFinite(v)) {
            double max = this.get();
            while (this.isGreaterThan(v, max) && !this.compareAndSet(max, v)) {
                max = this.get();
            }
        }
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

