/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.beans.Introspector;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.DoubleBinaryOperator;

final class MappingExpr {
    private MappingExpr() {
    }

    static String substitute(String pattern, Map<String, String> vars) {
        int openBracePos = pattern.indexOf(123);
        if (openBracePos == -1) {
            return pattern;
        }
        int closeBracePos = pattern.indexOf(125, openBracePos);
        if (closeBracePos == -1) {
            return pattern;
        }
        StringBuilder builder = new StringBuilder(pattern.length());
        int startPos = 0;
        while (startPos < pattern.length()) {
            String value;
            builder.append(pattern, startPos, openBracePos);
            String var = pattern.substring(openBracePos + 1, closeBracePos);
            boolean useRawValue = var.startsWith("raw:");
            String string = value = useRawValue ? vars.get(var.substring("raw:".length())) : vars.get(var);
            if (value == null) {
                builder.append('{').append(var).append('}');
            } else {
                builder.append(useRawValue ? value : Introspector.decapitalize(value));
            }
            if ((openBracePos = pattern.indexOf(123, startPos = closeBracePos + 1)) != -1 && (closeBracePos = pattern.indexOf(125, openBracePos)) != -1) continue;
            break;
        }
        if (startPos < pattern.length()) {
            builder.append(pattern, startPos, pattern.length());
        }
        return builder.toString();
    }

    static Double eval(String expr, Map<String, ? extends Number> vars) {
        String[] parts;
        ArrayDeque<Double> stack = new ArrayDeque<Double>();
        String[] stringArray = parts = expr.split("[,\\s]+");
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String part;
            switch (part = stringArray[i]) {
                case ":add": {
                    MappingExpr.binaryOp(stack, (a, b) -> a + b);
                    continue block14;
                }
                case ":sub": {
                    MappingExpr.binaryOp(stack, (a, b) -> a - b);
                    continue block14;
                }
                case ":mul": {
                    MappingExpr.binaryOp(stack, (a, b) -> a * b);
                    continue block14;
                }
                case ":div": {
                    MappingExpr.binaryOp(stack, (a, b) -> a / b);
                    continue block14;
                }
                case ":if-changed": {
                    MappingExpr.ifChanged(stack);
                    continue block14;
                }
                default: {
                    if (part.startsWith("{") && part.endsWith("}")) {
                        Number v = vars.get(part.substring(1, part.length() - 1));
                        if (v == null) {
                            v = Double.NaN;
                        }
                        stack.addFirst(v.doubleValue());
                        continue block14;
                    }
                    stack.addFirst(Double.parseDouble(part));
                }
            }
        }
        return (Double)stack.removeFirst();
    }

    private static void binaryOp(Deque<Double> stack, DoubleBinaryOperator op) {
        double b = stack.removeFirst();
        double a = stack.removeFirst();
        stack.addFirst(op.applyAsDouble(a, b));
    }

    private static void ifChanged(Deque<Double> stack) {
        double v2 = stack.removeFirst();
        double v1 = stack.removeFirst();
        double num = stack.removeFirst();
        stack.addFirst(Double.compare(v1, v2) == 0 ? 0.0 : num);
    }
}

