/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

final class PrefixTree<T> {
    private static final int FIRST_CHAR = 32;
    private static final int LAST_CHAR = 126;
    private static final int TABLE_SIZE = 95;
    private final Lock lock = new ReentrantLock();
    private final AtomicReferenceArray<PrefixTree<T>> children = new AtomicReferenceArray(95);
    private final Set<T> values = ConcurrentHashMap.newKeySet();

    private static int indexOf(char c) {
        int i = c - 32;
        return i >= 95 ? -1 : i;
    }

    PrefixTree() {
    }

    private PrefixTree<T> computeIfAbsent(int i) {
        PrefixTree<T> child = this.children.get(i);
        if (child == null) {
            this.lock.lock();
            try {
                child = this.children.get(i);
                if (child == null) {
                    child = new PrefixTree<T>();
                    this.children.set(i, child);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return child;
    }

    void put(String prefix, T value) {
        if (prefix == null) {
            this.values.add(value);
        } else {
            this.put(prefix, 0, value);
        }
    }

    private void put(String prefix, int pos, T value) {
        if (pos == prefix.length()) {
            this.values.add(value);
        } else {
            int i = PrefixTree.indexOf(prefix.charAt(pos));
            if (i < 0) {
                this.values.add(value);
            } else {
                PrefixTree<T> child = this.computeIfAbsent(i);
                super.put(prefix, pos + 1, value);
            }
        }
    }

    boolean remove(String prefix, T value) {
        if (prefix == null) {
            return this.values.remove(value);
        }
        return this.remove(prefix, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(String prefix, int pos, T value) {
        if (pos == prefix.length()) {
            return this.values.remove(value);
        }
        int i = PrefixTree.indexOf(prefix.charAt(pos));
        if (i < 0) {
            return this.values.remove(value);
        }
        PrefixTree<T> child = this.children.get(i);
        if (child == null) {
            return false;
        }
        boolean result = super.remove(prefix, pos + 1, value);
        if (result && child.isEmpty()) {
            this.lock.lock();
            try {
                if (child == this.children.get(i) && child.isEmpty()) {
                    this.children.set(i, null);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return result;
    }

    List<T> get(String key) {
        ArrayList results = new ArrayList();
        this.forEach(key, results::add);
        return results;
    }

    void forEach(String key, Consumer<T> consumer) {
        this.forEach(key, 0, consumer);
    }

    private void forEach(String key, int pos, Consumer<T> consumer) {
        PrefixTree<T> child;
        int i;
        this.values.forEach(consumer);
        if (pos < key.length() && (i = PrefixTree.indexOf(key.charAt(pos))) >= 0 && (child = this.children.get(i)) != null) {
            super.forEach(key, pos + 1, consumer);
        }
    }

    boolean isEmpty() {
        if (this.values.isEmpty()) {
            for (int i = 0; i < 95; ++i) {
                if (this.children.get(i) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    int size() {
        int sz = this.values.size();
        for (int i = 0; i < 95; ++i) {
            PrefixTree<T> child = this.children.get(i);
            if (child == null) continue;
            sz += child.size();
        }
        return sz;
    }
}

