/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Functions;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.NoopRegistry;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.api.Utils;
import spectator-agent.spectator.api.patterns.PolledMeter;

public final class IntervalCounter
implements Counter {
    private static final double MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final Clock clock;
    private final Id id;
    private final Counter counter;
    private final AtomicLong lastUpdated;

    public static IntervalCounter get(Registry registry, Id id) {
        ConcurrentMap<Id, Object> state = registry.state();
        Object c = Utils.computeIfAbsent(state, id, i -> new IntervalCounter(registry, (Id)i));
        if (!(c instanceof IntervalCounter)) {
            Utils.propagateTypeError(registry, id, IntervalCounter.class, c.getClass());
            c = new IntervalCounter(new NoopRegistry(), id);
        }
        return (IntervalCounter)c;
    }

    IntervalCounter(Registry registry, Id id) {
        this.clock = registry.clock();
        this.id = id;
        this.counter = registry.counter(id.withTag(Statistic.count));
        this.lastUpdated = ((PolledMeter.Builder)PolledMeter.using(registry).withId(id).withTag(Statistic.duration)).monitorValue(new AtomicLong(0L), Functions.age(this.clock));
    }

    @Override
    public void add(double amount) {
        this.counter.add(amount);
        this.lastUpdated.set(this.clock.wallTime());
    }

    @Override
    public double actualCount() {
        return this.counter.actualCount();
    }

    @Override
    public Id id() {
        return this.id;
    }

    public double secondsSinceLastUpdate() {
        long now = this.clock.wallTime();
        return (double)(now - this.lastUpdated.get()) / MILLIS_PER_SECOND;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

