/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;

final class DefaultDistributionSummary
implements DistributionSummary {
    private final Clock clock;
    private final Id id;
    private final AtomicLong count;
    private final AtomicLong totalAmount;

    DefaultDistributionSummary(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.count = new AtomicLong(0L);
        this.totalAmount = new AtomicLong(0L);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount) {
        if (amount >= 0L) {
            this.totalAmount.addAndGet(amount);
            this.count.incrementAndGet();
        }
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        ms.add(new Measurement(this.id.withTag(Statistic.count), now, this.count.get()));
        ms.add(new Measurement(this.id.withTag(Statistic.totalAmount), now, this.totalAmount.get()));
        return ms;
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public long totalAmount() {
        return this.totalAmount.get();
    }
}

