/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.CompositeCounter;
import spectator-agent.spectator.api.CompositeDistributionSummary;
import spectator-agent.spectator.api.CompositeGauge;
import spectator-agent.spectator.api.CompositeTimer;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DefaultId;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.NoopCounter;
import spectator-agent.spectator.api.NoopDistributionSummary;
import spectator-agent.spectator.api.NoopGauge;
import spectator-agent.spectator.api.NoopTimer;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.SwapCounter;
import spectator-agent.spectator.api.SwapDistributionSummary;
import spectator-agent.spectator.api.SwapGauge;
import spectator-agent.spectator.api.SwapTimer;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.api.patterns.PolledMeter;

public final class CompositeRegistry
implements Registry {
    private final Clock clock;
    private final AtomicReference<Registry[]> registries;
    private final AtomicLong version;
    private final LongSupplier versionSupplier;
    private final ConcurrentHashMap<Id, Object> state;

    CompositeRegistry(Clock clock) {
        this.clock = clock;
        this.registries = new AtomicReference<Registry[]>(new Registry[0]);
        this.version = new AtomicLong();
        this.versionSupplier = this.version::get;
        this.state = new ConcurrentHashMap();
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries.get()) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    private int indexOf(Registry[] rs, Registry registry) {
        for (int i = 0; i < rs.length; ++i) {
            if (!rs[i].equals(registry)) continue;
            return i;
        }
        return -1;
    }

    public synchronized void add(Registry registry) {
        Registry[] rs = this.registries.get();
        int pos = this.indexOf(rs, registry);
        if (pos == -1) {
            Registry[] tmp = new Registry[rs.length + 1];
            System.arraycopy(rs, 0, tmp, 0, rs.length);
            tmp[rs.length] = registry;
            this.registries.set(tmp);
            this.version.incrementAndGet();
        }
    }

    public synchronized void remove(Registry registry) {
        Registry[] rs = this.registries.get();
        int pos = this.indexOf(rs, registry);
        if (pos >= 0) {
            Registry[] tmp = new Registry[rs.length - 1];
            if (pos > 0) {
                System.arraycopy(rs, 0, tmp, 0, pos);
            }
            if (pos < tmp.length) {
                System.arraycopy(rs, pos + 1, tmp, pos, rs.length - pos - 1);
            }
            this.registries.set(tmp);
            this.version.incrementAndGet();
        }
    }

    public synchronized void removeAll() {
        this.registries.set(new Registry[0]);
        this.state.clear();
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    public Id createId(String name, String ... tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    public Id createId(String name, Map<String, String> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    @Deprecated
    public void register(Meter meter) {
        PolledMeter.monitorMeter(this, meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    private <T> List<T> meters(Registry[] rs, Id id, BiFunction<Registry, Id, T> f) {
        ArrayList<T> ms = new ArrayList<T>(rs.length);
        for (Registry r : rs) {
            ms.add(f.apply(r, id));
        }
        return ms;
    }

    private Counter newCounter(Id id) {
        Counter c;
        Registry[] rs = this.registries.get();
        switch (rs.length) {
            case 0: {
                c = NoopCounter.INSTANCE;
                break;
            }
            case 1: {
                c = rs[0].counter(id);
                break;
            }
            default: {
                List<Counter> cs = this.meters(rs, id, Registry::counter);
                c = new CompositeCounter(id, (Collection<Counter>)cs);
            }
        }
        return c;
    }

    @Override
    public Counter counter(Id id) {
        return new SwapCounter((Registry)this, this.versionSupplier, id, this.newCounter(id));
    }

    private DistributionSummary newDistributionSummary(Id id) {
        DistributionSummary t;
        Registry[] rs = this.registries.get();
        switch (rs.length) {
            case 0: {
                t = NoopDistributionSummary.INSTANCE;
                break;
            }
            case 1: {
                t = rs[0].distributionSummary(id);
                break;
            }
            default: {
                List<DistributionSummary> ds = this.meters(rs, id, Registry::distributionSummary);
                t = new CompositeDistributionSummary(id, (Collection<DistributionSummary>)ds);
            }
        }
        return t;
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new SwapDistributionSummary((Registry)this, this.versionSupplier, id, this.newDistributionSummary(id));
    }

    private Timer newTimer(Id id) {
        Timer t;
        Registry[] rs = this.registries.get();
        switch (rs.length) {
            case 0: {
                t = NoopTimer.INSTANCE;
                break;
            }
            case 1: {
                t = rs[0].timer(id);
                break;
            }
            default: {
                List<Timer> ts = this.meters(rs, id, Registry::timer);
                t = new CompositeTimer(id, this.clock, ts);
            }
        }
        return t;
    }

    @Override
    public Timer timer(Id id) {
        return new SwapTimer((Registry)this, this.versionSupplier, id, this.newTimer(id));
    }

    private Gauge newGauge(Id id) {
        Gauge t;
        Registry[] rs = this.registries.get();
        switch (rs.length) {
            case 0: {
                t = NoopGauge.INSTANCE;
                break;
            }
            case 1: {
                t = rs[0].gauge(id);
                break;
            }
            default: {
                List<Gauge> gs = this.meters(rs, id, Registry::gauge);
                t = new CompositeGauge(id, (Collection<Gauge>)gs);
            }
        }
        return t;
    }

    @Override
    public Gauge gauge(Id id) {
        return new SwapGauge((Registry)this, this.versionSupplier, id, this.newGauge(id));
    }

    private Gauge newMaxGauge(Id id) {
        Gauge t;
        Registry[] rs = this.registries.get();
        switch (rs.length) {
            case 0: {
                t = NoopGauge.INSTANCE;
                break;
            }
            case 1: {
                t = rs[0].maxGauge(id);
                break;
            }
            default: {
                List<Gauge> gs = this.meters(rs, id, Registry::maxGauge);
                t = new CompositeGauge(id, (Collection<Gauge>)gs);
            }
        }
        return t;
    }

    @Override
    public Gauge maxGauge(Id id) {
        return new SwapGauge((Registry)this, this.versionSupplier, id, this.newMaxGauge(id));
    }

    @Override
    public Meter get(Id id) {
        for (Registry r : this.registries.get()) {
            Meter m = r.get(id);
            if (m == null) continue;
            if (m instanceof Counter) {
                return this.counter(id);
            }
            if (m instanceof Timer) {
                return this.timer(id);
            }
            if (m instanceof DistributionSummary) {
                return this.distributionSummary(id);
            }
            if (m instanceof Gauge) {
                return this.gauge(id);
            }
            return null;
        }
        return null;
    }

    @Override
    public Iterator<Meter> iterator() {
        Registry[] rs = this.registries.get();
        if (rs.length == 0) {
            return Collections.emptyIterator();
        }
        final HashSet<Id> ids = new HashSet<Id>();
        for (Registry r : rs) {
            for (Meter m : r) {
                ids.add(m.id());
            }
        }
        return new Iterator<Meter>(){
            private final Iterator<Id> idIter;
            {
                this.idIter = ids.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.idIter.hasNext();
            }

            @Override
            public Meter next() {
                return CompositeRegistry.this.get(this.idIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

