/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc.http;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import spectator-agent.spectator.ipc.http.HttpResponse;

public interface RetryPolicy {
    public static final RetryPolicy ALL = new RetryPolicy(){

        @Override
        public boolean shouldRetry(String method, Throwable t) {
            return true;
        }

        @Override
        public boolean shouldRetry(String method, HttpResponse response) {
            return true;
        }
    };
    public static final RetryPolicy SAFE = new RetryPolicy(){

        @Override
        public boolean shouldRetry(String method, Throwable t) {
            return this.isConnectException(t) || this.allowedMethod(method);
        }

        private boolean isConnectException(Throwable t) {
            return t instanceof ConnectException || this.isConnectTimeout(t);
        }

        private boolean isConnectTimeout(Throwable t) {
            return t instanceof SocketTimeoutException && t.getMessage() != null && t.getMessage().toLowerCase(Locale.US).contains("connect");
        }

        @Override
        public boolean shouldRetry(String method, HttpResponse response) {
            return this.isThrottled(response.status()) || this.isAllowed(method, response);
        }

        private boolean isThrottled(int status) {
            return status == 429 || status == 503;
        }

        private boolean isAllowed(String method, HttpResponse response) {
            return this.allowedMethod(method) && this.allowedStatus(response.status());
        }

        private boolean allowedMethod(String method) {
            return "GET".equals(method) || "HEAD".equals(method);
        }

        private boolean allowedStatus(int status) {
            return status >= 500;
        }
    };

    public boolean shouldRetry(String var1, Throwable var2);

    public boolean shouldRetry(String var1, HttpResponse var2);
}

