/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.io.Serializable;
import java.util.Objects;
import spectator-agent.spectator.impl.matcher.Matcher;
import spectator-agent.spectator.impl.matcher.PatternUtils;

final class StartsWithMatcher
implements Matcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final boolean ignoreCase;

    StartsWithMatcher(String pattern) {
        this(pattern, false);
    }

    StartsWithMatcher(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    String pattern() {
        return this.pattern;
    }

    @Override
    public int matches(String str, int start, int length) {
        boolean matched = this.ignoreCase ? str.regionMatches(true, 0, this.pattern, 0, this.pattern.length()) : str.startsWith(this.pattern);
        return matched ? this.pattern.length() : -1;
    }

    @Override
    public String prefix() {
        return this.pattern;
    }

    @Override
    public int minLength() {
        return this.pattern.length();
    }

    @Override
    public boolean isStartAnchored() {
        return true;
    }

    public String toString() {
        return "^" + PatternUtils.escape(this.pattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartsWithMatcher that = (StartsWithMatcher)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + Boolean.hashCode(this.ignoreCase);
        return result;
    }
}

