/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MeasurementConsumer;
import spectator-agent.spectator.impl.StepDouble;
import spectator-agent.spectator.impl.StepLong;
import spectator-agent.spectator.impl.StepValue;

class AtlasDistributionSummary
extends AtlasMeter
implements DistributionSummary {
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasDistributionSummary(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(DsType.rate, Statistic.count), id.withTags(DsType.rate, Statistic.totalAmount), id.withTags(DsType.rate, Statistic.totalOfSquares), id.withTags(DsType.gauge, Statistic.max)};
    }

    @Override
    void measure(MeasurementConsumer consumer) {
        this.reportMeasurement(consumer, this.stats[0], this.count);
        this.reportMeasurement(consumer, this.stats[1], this.total);
        this.reportMeasurement(consumer, this.stats[2], this.totalOfSquares);
        this.reportMaxMeasurement(consumer, this.stats[3], this.max);
    }

    private void reportMeasurement(MeasurementConsumer consumer, Id mid, StepValue v) {
        double rate = v.pollAsRate();
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, rate);
    }

    private void reportMaxMeasurement(MeasurementConsumer consumer, Id mid, StepLong v) {
        double maxValue = v.poll();
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, maxValue);
    }

    @Override
    public void record(long amount) {
        this.count.getCurrent().incrementAndGet();
        if (amount > 0L) {
            this.total.getCurrent().addAndGet(amount);
            this.totalOfSquares.getCurrent().addAndGet((double)amount * (double)amount);
            this.updateMax(this.max.getCurrent(), amount);
        }
        this.updateLastModTime();
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    @Override
    public long count() {
        return this.count.poll();
    }

    @Override
    public long totalAmount() {
        return this.total.poll();
    }
}

