/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import spectator-agent.spectator.api.BasicTag;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.patterns.PolledMeter;
import spectator-agent.spectator.impl.Preconditions;

public final class ThreadPoolMonitor {
    static final String ID_TAG_NAME = "id";
    static final String DEFAULT_ID = "default";
    static final String TASK_COUNT = "threadpool.taskCount";
    static final String COMPLETED_TASK_COUNT = "threadpool.completedTaskCount";
    static final String REJECTED_TASK_COUNT = "threadpool.rejectedTaskCount";
    static final String CURRENT_THREADS_BUSY = "threadpool.currentThreadsBusy";
    static final String MAX_THREADS = "threadpool.maxThreads";
    static final String POOL_SIZE = "threadpool.poolSize";
    static final String CORE_POOL_SIZE = "threadpool.corePoolSize";
    static final String QUEUE_SIZE = "threadpool.queueSize";

    private ThreadPoolMonitor() {
    }

    public static void attach(Registry registry, ThreadPoolExecutor threadPool, String threadPoolName) {
        Preconditions.checkNotNull(registry, "registry");
        Preconditions.checkNotNull(threadPool, "threadPool");
        String idValue = threadPoolName == null || threadPoolName.isEmpty() ? DEFAULT_ID : threadPoolName;
        BasicTag idTag = new BasicTag(ID_TAG_NAME, idValue);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(TASK_COUNT).withTag(idTag)).monitorMonotonicCounter(threadPool, ThreadPoolExecutor::getTaskCount);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(COMPLETED_TASK_COUNT).withTag(idTag)).monitorMonotonicCounter(threadPool, ThreadPoolExecutor::getCompletedTaskCount);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(CURRENT_THREADS_BUSY).withTag(idTag)).monitorValue(threadPool, ThreadPoolExecutor::getActiveCount);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(MAX_THREADS).withTag(idTag)).monitorValue(threadPool, ThreadPoolExecutor::getMaximumPoolSize);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(POOL_SIZE).withTag(idTag)).monitorValue(threadPool, ThreadPoolExecutor::getPoolSize);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(CORE_POOL_SIZE).withTag(idTag)).monitorValue(threadPool, ThreadPoolExecutor::getCorePoolSize);
        ((PolledMeter.Builder)PolledMeter.using(registry).withName(QUEUE_SIZE).withTag(idTag)).monitorValue(threadPool, tp -> tp.getQueue().size());
        Counter rejected = registry.counter(registry.createId(REJECTED_TASK_COUNT).withTag(idTag));
        RejectedExecutionHandler handler = threadPool.getRejectedExecutionHandler();
        RejectedExecutionHandler monitoredHandler = (r, exec) -> {
            rejected.increment();
            handler.rejectedExecution(r, exec);
        };
        threadPool.setRejectedExecutionHandler(monitoredHandler);
    }
}

