/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.netflix.iep.config.ConfigListener;
import com.netflix.iep.config.DynamicConfigManager;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import spectator-agent.config.Config;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;

final class DynamicConfigManagerImpl
implements DynamicConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicConfigManagerImpl.class);
    private final Config baseConfig;
    private volatile Config current;
    private final Set<ConfigListener> listeners = ConcurrentHashMap.newKeySet();

    DynamicConfigManagerImpl(Config config) {
        this.baseConfig = config;
        this.current = config;
    }

    @Override
    public Config get() {
        return this.current;
    }

    @Override
    public synchronized void setOverrideConfig(Config config) {
        Config config2 = this.current;
        this.current = config.withFallback(this.baseConfig).resolve();
        this.listeners.forEach(configListener -> this.invokeListener((ConfigListener)configListener, config2, this.current));
    }

    private void invokeListener(ConfigListener configListener, Config config, Config config2) {
        try {
            configListener.onUpdate(config, config2);
        }
        catch (Exception exception) {
            LOGGER.warn("failed to update a listener", exception);
        }
    }

    @Override
    public void addListener(ConfigListener configListener) {
        this.listeners.add(configListener);
        this.invokeListener(configListener, null, this.current);
    }

    @Override
    public void removeListener(ConfigListener configListener) {
        this.listeners.remove(configListener);
    }
}

