/*
 * Decompiled with CFR 0.152.
 */
package spectator-atlas.json.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import spectator-atlas.json.core.JsonGenerator;
import spectator-atlas.json.core.JsonToken;
import spectator-atlas.json.core.type.WritableTypeId;
import spectator-atlas.json.databind.JavaType;
import spectator-atlas.json.databind.JsonMappingException;
import spectator-atlas.json.databind.JsonNode;
import spectator-atlas.json.databind.SerializationFeature;
import spectator-atlas.json.databind.SerializerProvider;
import spectator-atlas.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import spectator-atlas.json.databind.jsontype.TypeSerializer;
import spectator-atlas.json.databind.ser.std.StdSerializer;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        gen.writeStartObject();
        gen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value) throws JsonMappingException {
        prov.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value.getClass().getName()));
    }
}

