/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl;

import java.util.function.LongSupplier;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;

public abstract class SwapMeter<T extends Meter>
implements Meter {
    protected final Registry registry;
    private final LongSupplier versionSupplier;
    private volatile long currentVersion;
    protected final Id id;
    private volatile T underlying;

    public SwapMeter(Registry registry, LongSupplier versionSupplier, Id id, T underlying) {
        this.registry = registry;
        this.versionSupplier = versionSupplier;
        this.currentVersion = versionSupplier.getAsLong();
        this.id = id;
        this.underlying = this.unwrap(underlying);
    }

    public abstract T lookup();

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        return this.currentVersion < this.versionSupplier.getAsLong() || this.underlying.hasExpired();
    }

    public void set(T meter) {
        this.underlying = this.unwrap(meter);
    }

    public T get() {
        if (this.hasExpired()) {
            this.currentVersion = this.versionSupplier.getAsLong();
            this.underlying = this.unwrap(this.lookup());
        }
        return this.underlying;
    }

    private T unwrap(T meter) {
        T tmp = meter;
        while (tmp instanceof SwapMeter && this.registry == ((SwapMeter)tmp).registry) {
            tmp = ((SwapMeter)tmp).underlying;
        }
        return tmp;
    }
}

