/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.impl.Cache;

class LfuCache<K, V>
implements Cache<K, V> {
    private final Counter hits;
    private final Counter misses;
    private final Counter compactions;
    private final ConcurrentHashMap<K, Pair<V>> data;
    private final int baseSize;
    private final int compactionSize;
    private final AtomicInteger size;
    private final Lock lock;

    LfuCache(Registry registry, String id, int baseSize, int compactionSize) {
        this.hits = registry.counter("spectator.cache.requests", "id", id, "result", "hit");
        this.misses = registry.counter("spectator.cache.requests", "id", id, "result", "miss");
        this.compactions = registry.counter("spectator.cache.compactions", "id", id);
        this.data = new ConcurrentHashMap();
        this.baseSize = baseSize;
        this.compactionSize = compactionSize;
        this.size = new AtomicInteger();
        this.lock = new ReentrantLock();
    }

    private void compact() {
        HashMap snapshot = new HashMap();
        this.data.forEach((k, v) -> snapshot.put(k, v.snapshot()));
        snapshot.entrySet().stream().sorted(Comparator.comparingLong(e -> ((Snapshot)e.getValue()).negativeCount())).skip(this.baseSize).forEach(e -> this.data.remove(e.getKey()));
        this.size.set(this.data.size());
        this.compactions.increment();
    }

    private void tryCompact() {
        if (this.lock.tryLock()) {
            try {
                this.compact();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public V get(K key) {
        Pair<V> value = this.data.get(key);
        if (value == null) {
            this.misses.increment();
            return null;
        }
        this.hits.increment();
        return value.get();
    }

    @Override
    public V peek(K key) {
        Pair<V> value = this.data.get(key);
        return value == null ? null : (V)value.peek();
    }

    @Override
    public void put(K key, V value) {
        Pair<V> prev = this.data.put(key, new Pair<V>(value));
        if (prev == null && this.size.incrementAndGet() > this.compactionSize) {
            this.tryCompact();
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> f) {
        Pair<V> value = this.data.get(key);
        if (value == null) {
            this.misses.increment();
            Pair<V> tmp = new Pair<V>(f.apply(key));
            value = this.data.putIfAbsent(key, tmp);
            if (value == null) {
                value = tmp;
                if (this.size.incrementAndGet() > this.compactionSize) {
                    this.tryCompact();
                }
            }
        } else {
            this.hits.increment();
        }
        return value.get();
    }

    @Override
    public void clear() {
        this.size.set(0);
        this.data.clear();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public Map<K, V> asMap() {
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Pair)e.getValue()).peek()));
    }

    private static class Snapshot<V> {
        private V value;
        private long count;

        Snapshot(V value, long count) {
            this.value = value;
            this.count = count;
        }

        V get() {
            return this.value;
        }

        long negativeCount() {
            return -this.count;
        }
    }

    private static class Pair<V> {
        private V value;
        private LongAdder count;

        Pair(V value) {
            this.value = value;
            this.count = new LongAdder();
        }

        V get() {
            this.count.increment();
            return this.value;
        }

        V peek() {
            return this.value;
        }

        Snapshot<V> snapshot() {
            return new Snapshot<V>(this.value, this.count.sum());
        }
    }
}

