/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import spectator-agent.spectator.api.Tag;

public interface TagList
extends Iterable<Tag> {
    public String getKey(int var1);

    public String getValue(int var1);

    public int size();

    default public Tag getTag(int i) {
        return Tag.of(this.getKey(i), this.getValue(i));
    }

    default public void forEach(BiConsumer<String, String> consumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.getKey(i), this.getValue(i));
        }
    }

    @Override
    default public Iterator<Tag> iterator() {
        final int length = this.size();
        return new Iterator<Tag>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < length;
            }

            @Override
            public Tag next() {
                if (this.i >= length) {
                    throw new NoSuchElementException("next called after end of iterator");
                }
                return TagList.this.getTag(this.i++);
            }
        };
    }
}

