/*
 * Decompiled with CFR 0.152.
 */
package spectator-atlas.json.databind.deser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import spectator-atlas.json.core.JsonParser;
import spectator-atlas.json.databind.DeserializationContext;
import spectator-atlas.json.databind.deser.std.StdScalarDeserializer;
import spectator-atlas.json.databind.util.ByteBufferBackedOutputStream;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

