/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.io.IOException;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.impl.AsciiSet;
import spectator-atlas.json.core.JsonGenerator;
import spectator-atlas.json.databind.JsonSerializer;
import spectator-atlas.json.databind.SerializerProvider;

public class MeasurementSerializer
extends JsonSerializer<Measurement> {
    private final AsciiSet set;

    public MeasurementSerializer(AsciiSet set) {
        this.set = set;
    }

    private String fix(String s) {
        return this.set.replaceNonMembers(s, '_');
    }

    @Override
    public void serialize(Measurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Id id = value.id();
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        gen.writeStringField("name", this.fix(id.name()));
        boolean explicitDsType = false;
        int n = id.size();
        for (int i = 1; i < n; ++i) {
            String k = this.fix(id.getKey(i));
            String v = this.fix(id.getValue(i));
            if ("name".equals(k)) continue;
            if ("atlas.dstype".equals(k)) {
                explicitDsType = true;
            }
            gen.writeStringField(k, v);
        }
        if (!explicitDsType) {
            gen.writeStringField("atlas.dstype", "gauge");
        }
        gen.writeEndObject();
        gen.writeNumberField("timestamp", value.timestamp());
        gen.writeNumberField("value", value.value());
        gen.writeEndObject();
    }
}

