/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.ipc.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.impl.Preconditions;
import spectator-agent.spectator.ipc.IpcLogEntry;
import spectator-agent.spectator.ipc.IpcLogger;
import spectator-agent.spectator.ipc.NetflixHeaders;
import spectator-agent.spectator.ipc.http.HttpResponse;
import spectator-agent.spectator.ipc.http.HttpUtils;

public class HttpRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestBuilder.class);
    private static final Map<String, String> NETFLIX_HEADERS = NetflixHeaders.extractFromEnvironment();
    private static volatile ExecutorService defaultExecutor;
    private final URI uri;
    private final IpcLogEntry entry;
    private String method = "GET";
    private Map<String, String> reqHeaders = new LinkedHashMap<String, String>();
    private byte[] entity = HttpUtils.EMPTY;
    private int connectTimeout = 1000;
    private int readTimeout = 30000;
    private long initialRetryDelay = 1000L;
    private int numAttempts = 1;
    private HostnameVerifier hostVerifier = null;
    private SSLSocketFactory sslFactory = null;

    private static ThreadFactory newThreadFactory() {
        return new ThreadFactory(){
            private final AtomicInteger next = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String name = "spectator-ipc-" + this.next.getAndIncrement();
                Thread t = new Thread(r, name);
                t.setDaemon(true);
                return t;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService defaultExecutor() {
        ExecutorService executor = defaultExecutor;
        if (executor != null) {
            return executor;
        }
        Logger logger = LOGGER;
        synchronized (logger) {
            defaultExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), HttpRequestBuilder.newThreadFactory());
            return defaultExecutor;
        }
    }

    public HttpRequestBuilder(IpcLogger logger, URI uri) {
        this.uri = uri;
        this.entry = logger.createClientEntry().withOwner("spectator").withUri(uri).withHttpMethod(this.method);
        this.reqHeaders.putAll(NETFLIX_HEADERS);
    }

    public HttpRequestBuilder withMethod(String m) {
        this.method = m;
        this.entry.withHttpMethod(this.method);
        return this;
    }

    public HttpRequestBuilder addHeader(String name, String value) {
        if (value != null) {
            this.reqHeaders.put(name, value);
        }
        return this;
    }

    public HttpRequestBuilder userAgent(String agent) {
        return this.addHeader("User-Agent", agent);
    }

    public HttpRequestBuilder acceptJson() {
        return this.addHeader("Accept", "application/json");
    }

    public HttpRequestBuilder accept(String type) {
        return this.addHeader("Accept", type);
    }

    public HttpRequestBuilder acceptGzip() {
        return this.acceptEncoding("gzip");
    }

    public HttpRequestBuilder acceptEncoding(String enc) {
        return this.addHeader("Accept-Encoding", enc);
    }

    public HttpRequestBuilder withConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public HttpRequestBuilder withReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public HttpRequestBuilder withJsonContent(String content) {
        return this.withContent("application/json", content);
    }

    public HttpRequestBuilder withContent(String type, String content) {
        return this.withContent(type, content.getBytes(StandardCharsets.UTF_8));
    }

    public HttpRequestBuilder withContent(String type, byte[] content) {
        this.addHeader("Content-Type", type);
        this.entity = content;
        return this;
    }

    public HttpRequestBuilder compress() throws IOException {
        return this.compress(-1);
    }

    public HttpRequestBuilder compress(int level) throws IOException {
        this.addHeader("Content-Encoding", "gzip");
        this.entity = HttpUtils.gzip(this.entity, level);
        return this;
    }

    public HttpRequestBuilder withRetries(int n) {
        Preconditions.checkArg(n >= 0, "number of retries must be >= 0");
        this.numAttempts = n + 1;
        return this;
    }

    public HttpRequestBuilder withInitialRetryDelay(long delay) {
        Preconditions.checkArg(delay >= 0L, "initial retry delay must be >= 0");
        this.initialRetryDelay = delay;
        return this;
    }

    private void requireHttps(String msg) {
        Preconditions.checkState("https".equals(this.uri.getScheme()), msg);
    }

    public HttpRequestBuilder withHostnameVerifier(HostnameVerifier verifier) {
        this.requireHttps("hostname verification cannot be used with http, switch to https");
        this.hostVerifier = verifier;
        return this;
    }

    public HttpRequestBuilder allowAllHosts() {
        return this.withHostnameVerifier((host, session) -> true);
    }

    public HttpRequestBuilder withSSLSocketFactory(SSLSocketFactory factory) {
        this.requireHttps("ssl cannot be used with http, use https");
        this.sslFactory = factory;
        return this;
    }

    public HttpRequestBuilder customizeLogging(Consumer<IpcLogEntry> f) {
        f.accept(this.entry);
        return this;
    }

    public HttpResponse send() throws IOException {
        HttpResponse response = null;
        for (int attempt = 1; attempt <= this.numAttempts; ++attempt) {
            this.entry.withAttempt(attempt).withAttemptFinal(attempt == this.numAttempts);
            try {
                response = this.sendImpl();
                int s = response.status();
                if (s == 429 || s == 503) {
                    try {
                        long delay = this.initialRetryDelay << attempt - 1;
                        LOGGER.debug("request throttled, delaying for {}ms: {} {}", delay, this.method, this.uri);
                        Thread.sleep(delay);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("request failed " + this.method + " " + this.uri, e);
                    }
                }
                if (s >= 500) continue;
                return response;
            }
            catch (IOException e) {
                if (attempt == this.numAttempts) {
                    throw e;
                }
                LOGGER.warn("attempt {} of {} failed: {} {}", attempt, this.numAttempts, this.method, this.uri);
            }
        }
        if (response == null) {
            throw new IOException("request failed " + this.method + " " + this.uri);
        }
        return response;
    }

    public CompletableFuture<HttpResponse> sendAsync() {
        Supplier<HttpResponse> responseSupplier = () -> {
            try {
                return this.send();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return CompletableFuture.supplyAsync(responseSupplier, HttpRequestBuilder.defaultExecutor());
    }

    private void configureHTTPS(HttpURLConnection http) {
        if (http instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)http;
            if (this.hostVerifier != null) {
                https.setHostnameVerifier(this.hostVerifier);
            }
            if (this.sslFactory != null) {
                https.setSSLSocketFactory(this.sslFactory);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected HttpResponse sendImpl() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] readAll(InputStream in) throws IOException {
        int length;
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) > 0) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }
}

