/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.BasicTag;
import spectator-agent.spectator.api.DefaultId;
import spectator-agent.spectator.api.FilteredIterator;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.TagList;
import spectator-agent.spectator.impl.Preconditions;

public final class Utils {
    private static final Logger REGISTRY_LOGGER = LoggerFactory.getLogger(Registry.class);

    private Utils() {
    }

    static Method getMethod(Class<?> cls, String name) throws NoSuchMethodException {
        NoSuchMethodException firstExc = null;
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (firstExc != null) continue;
                firstExc = e;
                continue;
            }
        }
        throw firstExc;
    }

    static Method getGaugeMethod(Registry registry, Id id, Object obj, String method) {
        try {
            Method m = Utils.getMethod(obj.getClass(), method);
            try {
                Number n = (Number)m.invoke(obj, new Object[0]);
                REGISTRY_LOGGER.debug("registering gauge {}, using method [{}], with initial value {}", id, m, n);
                return m;
            }
            catch (Exception e) {
                String msg = "exception thrown invoking method [" + m + "], skipping registration of gauge " + id;
                registry.propagate(msg, e);
            }
        }
        catch (NoSuchMethodException e) {
            String mname = obj.getClass().getName() + "." + method;
            String msg = "invalid method [" + mname + "], skipping registration of gauge " + id;
            registry.propagate(msg, e);
        }
        return null;
    }

    public static Id normalize(Id id) {
        return ((DefaultId)new DefaultId(id.name()).withTags((Iterable)id.tags())).normalize();
    }

    public static String getTagValue(Id id, String k) {
        Preconditions.checkNotNull(id, "id");
        return Utils.getTagValue(id.tags(), k);
    }

    public static String getTagValue(Iterable<Tag> tags, String k) {
        Preconditions.checkNotNull(tags, "tags");
        Preconditions.checkNotNull(k, "key");
        if (tags instanceof TagList) {
            TagList list = (TagList)tags;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!k.equals(list.getKey(i))) continue;
                return list.getValue(i);
            }
        } else {
            for (Tag t : tags) {
                if (!k.equals(t.key())) continue;
                return t.value();
            }
        }
        return null;
    }

    public static <T> T getValue(Iterable<T> values, int pos) {
        if (values instanceof List) {
            List vs = (List)values;
            return (T)vs.get(pos);
        }
        int i = 0;
        for (T v : values) {
            if (i == pos) {
                return v;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(pos + " >= " + i);
    }

    public static Measurement first(Iterable<Measurement> ms, Tag t) {
        return Utils.first(ms, t.key(), t.value());
    }

    public static Measurement first(Iterable<Measurement> ms, String k, String v) {
        return Utils.first(ms, (Measurement value) -> v.equals(Utils.getTagValue(value.id(), k)));
    }

    public static Measurement first(Iterable<Measurement> ms, Predicate<Measurement> p) {
        Iterator<Measurement> it = Utils.filter(ms, p).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, Tag t) {
        return Utils.filter(ms, t.key(), t.value());
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, String k, String v) {
        return Utils.filter(ms, (Measurement value) -> v.equals(Utils.getTagValue(value.id(), k)));
    }

    public static Iterable<Measurement> filter(Iterable<Measurement> ms, Predicate<Measurement> p) {
        return () -> new FilteredIterator(ms.iterator(), p);
    }

    public static <T> List<T> toList(Iterable<T> iter) {
        ArrayList<T> buf = new ArrayList<T>();
        for (T v : iter) {
            buf.add(v);
        }
        return buf;
    }

    public static <T> List<T> toList(Iterator<T> iter) {
        ArrayList<T> buf = new ArrayList<T>();
        while (iter.hasNext()) {
            buf.add(iter.next());
        }
        return buf;
    }

    public static <T> int size(Iterable<T> iter) {
        if (iter instanceof TagList) {
            return ((TagList)iter).size();
        }
        if (iter instanceof Collection) {
            return ((Collection)iter).size();
        }
        int size = 0;
        for (T v : iter) {
            ++size;
        }
        return size;
    }

    static Iterable<Tag> toIterable(String[] tags) {
        if (tags.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        ArrayList<Tag> ts = new ArrayList<Tag>(tags.length / 2);
        for (int i = 0; i < tags.length; i += 2) {
            ts.add(new BasicTag(tags[i], tags[i + 1]));
        }
        return ts;
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K k, Function<K, V> f) {
        V tmp;
        Object v = map.get(k);
        if (v == null && (v = map.putIfAbsent(k, tmp = f.apply(k))) == null) {
            v = tmp;
        }
        return v;
    }

    public static void propagateTypeError(Registry registry, Id id, Class<?> desiredClass, Class<?> actualClass) {
        String dType = desiredClass.getName();
        String aType = actualClass.getName();
        String msg = String.format("cannot access '%s' as a %s, it already exists as a %s", id, dType, aType);
        registry.propagate(new IllegalStateException(msg));
    }
}

