/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.impl.Preconditions;

final class DefaultId
implements Id {
    private final String name;
    private final ArrayTagSet tags;

    DefaultId(String name) {
        this(name, ArrayTagSet.EMPTY);
    }

    DefaultId(String name, ArrayTagSet tags) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.tags = Preconditions.checkNotNull(tags, "tags");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<Tag> tags() {
        return this.tags;
    }

    @Override
    public DefaultId withTag(Tag tag) {
        return new DefaultId(this.name, this.tags.add(tag));
    }

    @Override
    public DefaultId withTag(String key, String value) {
        return new DefaultId(this.name, this.tags.add(key, value));
    }

    @Override
    public DefaultId withTags(String ... ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Tag ... ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Iterable<Tag> ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Map<String, String> ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public String getKey(int i) {
        return i == 0 ? "name" : this.tags.getKey(i - 1);
    }

    @Override
    public String getValue(int i) {
        return i == 0 ? this.name : this.tags.getValue(i - 1);
    }

    @Override
    public int size() {
        return this.tags.size() + 1;
    }

    DefaultId normalize() {
        return this.rollup(Collections.emptySet(), false);
    }

    DefaultId rollup(Set<String> keys, boolean keep) {
        if (this.tags.isEmpty()) {
            return this;
        }
        TreeMap<String, String> ts = new TreeMap<String, String>();
        for (Tag t : this.tags) {
            if (keys.contains(t.key()) != keep || ts.containsKey(t.key())) continue;
            ts.put(t.key(), t.value());
        }
        return new DefaultId(this.name, ArrayTagSet.create(ts));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultId)) {
            return false;
        }
        DefaultId other = (DefaultId)obj;
        return this.name.equals(other.name) && this.tags.equals(other.tags);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    public String toString() {
        return this.name + this.tags;
    }
}

