/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import spectator-agent.json.jackson.core.JsonFactory;
import spectator-agent.json.jackson.databind.ObjectMapper;
import spectator-agent.json.jackson.databind.module.SimpleModule;
import spectator-agent.json.jackson.dataformat.smile.SmileFactory;
import spectator-agent.spectator.api.AbstractRegistry;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.atlas.AtlasConfig;
import spectator-agent.spectator.atlas.AtlasCounter;
import spectator-agent.spectator.atlas.AtlasDistributionSummary;
import spectator-agent.spectator.atlas.AtlasGauge;
import spectator-agent.spectator.atlas.AtlasMaxGauge;
import spectator-agent.spectator.atlas.AtlasTimer;
import spectator-agent.spectator.atlas.RollupPolicy;
import spectator-agent.spectator.atlas.StepClock;
import spectator-agent.spectator.atlas.SubscriptionManager;
import spectator-agent.spectator.atlas.impl.EvalPayload;
import spectator-agent.spectator.atlas.impl.Evaluator;
import spectator-agent.spectator.atlas.impl.MeasurementSerializer;
import spectator-agent.spectator.atlas.impl.PublishPayload;
import spectator-agent.spectator.atlas.impl.Subscription;
import spectator-agent.spectator.atlas.impl.TagsValuePair;
import spectator-agent.spectator.impl.AsciiSet;
import spectator-agent.spectator.impl.Scheduler;
import spectator-agent.spectator.ipc.http.HttpClient;
import spectator-agent.spectator.ipc.http.HttpResponse;

@Singleton
public final class AtlasRegistry
extends AbstractRegistry
implements AutoCloseable {
    private static final String CLOCK_SKEW_TIMER = "spectator.atlas.clockSkew";
    private final Clock stepClock;
    private final AtlasConfig config;
    private final Duration step;
    private final long stepMillis;
    private final long meterTTL;
    private final URI uri;
    private final Duration configRefreshFrequency;
    private final URI evalUri;
    private final int connectTimeout;
    private final int readTimeout;
    private final int batchSize;
    private final int numThreads;
    private final Map<String, String> commonTags;
    private final AsciiSet charset;
    private final Map<String, AsciiSet> overrides;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final Registry debugRegistry;
    private final RollupPolicy rollupPolicy;
    private final HttpClient client;
    private Scheduler scheduler;
    private final SubscriptionManager subManager;

    @Inject
    public AtlasRegistry(Clock clock, AtlasConfig config) {
        super(clock, config);
        this.config = config;
        this.stepClock = new StepClock(clock, config.step().toMillis());
        this.step = config.step();
        this.stepMillis = this.step.toMillis();
        this.meterTTL = config.meterTTL().toMillis();
        this.uri = URI.create(config.uri());
        this.configRefreshFrequency = config.configRefreshFrequency();
        this.evalUri = URI.create(config.evalUri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.batchSize = config.batchSize();
        this.numThreads = config.numThreads();
        this.commonTags = new TreeMap<String, String>(config.commonTags());
        this.charset = AsciiSet.fromPattern(config.validTagCharacters());
        this.overrides = config.validTagValueCharacters().keySet().stream().collect(Collectors.toMap(k -> k, AsciiSet::fromPattern));
        SimpleModule module = new SimpleModule().addSerializer(Measurement.class, new MeasurementSerializer(this.charset, this.overrides));
        this.jsonMapper = new ObjectMapper(new JsonFactory()).registerModule(module);
        this.smileMapper = new ObjectMapper(new SmileFactory()).registerModule(module);
        this.debugRegistry = Optional.ofNullable(config.debugRegistry()).orElse(this);
        this.rollupPolicy = config.rollupPolicy();
        this.client = HttpClient.create(this.debugRegistry);
        this.subManager = new SubscriptionManager(this.jsonMapper, this.client, clock, config);
        if (config.autoStart()) {
            this.start();
        }
    }

    public void start() {
        if (this.scheduler == null) {
            Scheduler.Options options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_RATE_SKIP_IF_LONG, this.step).withInitialDelay(Duration.ofMillis(this.getInitialDelay(this.stepMillis))).withStopOnFailure(false);
            this.scheduler = new Scheduler(this.debugRegistry, "spectator-reg-atlas", this.numThreads);
            this.scheduler.schedule(options, this::collectData);
            this.logger.info("started collecting metrics every {} reporting to {}", (Object)this.step, (Object)this.uri);
            this.logger.info("common tags: {}", (Object)this.commonTags);
            Scheduler.Options subOptions = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_DELAY, this.configRefreshFrequency).withStopOnFailure(false);
            this.scheduler.schedule(subOptions, this::fetchSubscriptions);
        } else {
            this.logger.warn("registry already started, ignoring duplicate request");
        }
    }

    long getInitialDelay(long stepSize) {
        long offset;
        long stepBoundary;
        long now = this.clock().wallTime();
        long delay = now - (stepBoundary = now / stepSize * stepSize);
        if (delay < (offset = stepSize / 10L)) {
            return delay + offset;
        }
        if (delay > stepSize - offset) {
            return stepSize - offset;
        }
        return delay;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.logger.info("stopped collecting metrics every {}ms reporting to {}", (Object)this.step, (Object)this.uri);
        } else {
            this.logger.warn("registry stopped, but was never started");
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    void collectData() {
        if (this.config.lwcEnabled()) {
            try {
                this.handleSubscriptions();
            }
            catch (Exception e) {
                this.logger.warn("failed to handle subscriptions", e);
            }
        } else {
            this.logger.debug("lwc is disabled, skipping subscriptions");
        }
        if (this.config.enabled()) {
            try {
                for (List<Measurement> batch : this.getBatches()) {
                    HttpResponse res;
                    Instant date;
                    PublishPayload p = new PublishPayload(this.commonTags, batch);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("publish payload: {}", (Object)this.jsonMapper.writeValueAsString(p));
                    }
                    this.recordClockSkew((date = (res = this.client.post(this.uri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withContent("application/x-jackson-smile", this.smileMapper.writeValueAsBytes(p)).compress(1).send()).dateHeader("Date")) == null ? 0L : date.toEpochMilli());
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics (uri={})", (Object)this.uri, (Object)e);
            }
        } else {
            this.logger.debug("publishing is disabled, skipping collection");
        }
        this.removeExpiredMeters();
    }

    @Override
    public void removeExpiredMeters() {
        super.removeExpiredMeters();
    }

    private void handleSubscriptions() {
        List<Subscription> subs = this.subManager.subscriptions();
        if (!subs.isEmpty()) {
            List<TagsValuePair> ms = this.measurements().map(this::newTagsValuePair).collect(Collectors.toList());
            Evaluator evaluator = new Evaluator().addGroupSubscriptions("local", subs);
            EvalPayload payload = evaluator.eval("local", this.stepClock.wallTime(), ms);
            try {
                String json = this.jsonMapper.writeValueAsString(payload);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("eval payload: {}", (Object)json);
                }
                this.client.post(this.evalUri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withJsonContent(json).send().decompress();
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics for subscriptions (uri={})", (Object)this.evalUri, (Object)e);
            }
        }
    }

    private void fetchSubscriptions() {
        if (this.config.lwcEnabled()) {
            this.subManager.refresh();
        } else {
            this.logger.debug("lwc is disabled, skipping subscription config refresh");
        }
    }

    private void recordClockSkew(long responseTimestamp) {
        if (responseTimestamp == 0L) {
            this.logger.debug("no date timestamp on response, cannot record skew");
        } else {
            long delta = this.clock().wallTime() - responseTimestamp;
            if (delta >= 0L) {
                this.debugRegistry.timer(CLOCK_SKEW_TIMER, "id", "fast").record(delta, TimeUnit.MILLISECONDS);
            } else {
                this.debugRegistry.timer(CLOCK_SKEW_TIMER, "id", "slow").record(-delta, TimeUnit.MILLISECONDS);
            }
            this.logger.debug("clock skew between client and server: {}ms", (Object)delta);
        }
    }

    private Map<String, String> toMap(Id id) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Tag t : id.tags()) {
            String k = this.charset.replaceNonMembers(t.key(), '_');
            String v = this.overrides.getOrDefault(k, this.charset).replaceNonMembers(t.value(), '_');
            tags.put(k, v);
        }
        String name = this.overrides.getOrDefault("name", this.charset).replaceNonMembers(id.name(), '_');
        tags.put("name", name);
        return tags;
    }

    private TagsValuePair newTagsValuePair(Measurement m) {
        Map<String, String> tags = this.toMap(m.id());
        tags.putAll(this.commonTags);
        return new TagsValuePair(tags, m.value());
    }

    List<List<Measurement>> getBatches() {
        List input = this.measurements().collect(Collectors.toList());
        this.debugRegistry.distributionSummary("spectator.registrySize").record(input.size());
        List ms = (List)this.rollupPolicy.apply(input);
        this.debugRegistry.distributionSummary("spectator.rollupResultSize").record(ms.size());
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    @Override
    protected Counter newCounter(Id id) {
        return new AtlasCounter(id, this.clock(), this.meterTTL, this.stepMillis);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Id id) {
        return new AtlasDistributionSummary(id, this.clock(), this.meterTTL, this.stepMillis);
    }

    @Override
    protected Timer newTimer(Id id) {
        return new AtlasTimer(id, this.clock(), this.meterTTL, this.stepMillis);
    }

    @Override
    protected Gauge newGauge(Id id) {
        return new AtlasGauge(id, this.stepClock, this.meterTTL);
    }

    @Override
    protected Gauge newMaxGauge(Id id) {
        return new AtlasMaxGauge(id, this.clock(), this.meterTTL, this.stepMillis);
    }
}

