/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import spectator-agent.spectator.api.Id;

public final class Measurement {
    private final Id id;
    private final long timestamp;
    private final double value;

    public Measurement(Id id, long timestamp, double value) {
        this.id = id;
        this.timestamp = timestamp;
        this.value = value;
    }

    public Id id() {
        return this.id;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public double value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Measurement)) {
            return false;
        }
        Measurement other = (Measurement)obj;
        return this.id.equals(other.id) && this.timestamp == other.timestamp && Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        int prime = 31;
        int hc = 31;
        hc = 31 * hc + this.id.hashCode();
        hc = 31 * hc + Long.valueOf(this.timestamp).hashCode();
        hc = 31 * hc + Double.valueOf(this.value).hashCode();
        return hc;
    }

    public String toString() {
        return "Measurement(" + this.id.toString() + "," + this.timestamp + "," + this.value + ")";
    }
}

