/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import spectator-agent.spectator.api.RegistryConfig;

public interface AtlasConfig
extends RegistryConfig {
    default public Duration step() {
        String v = this.get("atlas.step");
        return v == null ? Duration.ofMinutes(1L) : Duration.parse(v);
    }

    default public Duration meterTTL() {
        String v = this.get("atlas.meterTTL");
        return v == null ? Duration.ofMinutes(15L) : Duration.parse(v);
    }

    default public boolean enabled() {
        String v = this.get("atlas.enabled");
        return v == null || Boolean.valueOf(v) != false;
    }

    default public int numThreads() {
        String v = this.get("atlas.numThreads");
        return v == null ? 2 : Integer.parseInt(v);
    }

    default public String uri() {
        String v = this.get("atlas.uri");
        return v == null ? "http://localhost:7101/api/v1/publish" : v;
    }

    default public boolean lwcEnabled() {
        String v = this.get("atlas.lwc.enabled");
        return v != null && Boolean.valueOf(v) != false;
    }

    default public Duration configRefreshFrequency() {
        String v = this.get("atlas.configRefreshFrequency");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public Duration configTTL() {
        return this.configRefreshFrequency().multipliedBy(15L);
    }

    default public String configUri() {
        String v = this.get("atlas.config-uri");
        return v == null ? "http://localhost:7101/lwc/api/v1/expressions/local-dev" : v;
    }

    default public String evalUri() {
        String v = this.get("atlas.eval-uri");
        return v == null ? "http://localhost:7101/lwc/api/v1/evaluate" : v;
    }

    default public Duration connectTimeout() {
        String v = this.get("atlas.connectTimeout");
        return v == null ? Duration.ofSeconds(1L) : Duration.parse(v);
    }

    default public Duration readTimeout() {
        String v = this.get("atlas.readTimeout");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public int batchSize() {
        String v = this.get("atlas.batchSize");
        return v == null ? 10000 : Integer.parseInt(v);
    }

    default public Map<String, String> commonTags() {
        return Collections.emptyMap();
    }

    default public String validTagCharacters() {
        return "-._A-Za-z0-9~^";
    }

    default public Map<String, String> validTagValueCharacters() {
        return Collections.emptyMap();
    }
}

