/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import spectator-agent.config.Config;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.jvm.BufferPoolMeter;
import spectator-agent.spectator.jvm.JmxConfig;
import spectator-agent.spectator.jvm.JmxMeter;
import spectator-agent.spectator.jvm.MemoryPoolMeter;

public final class Jmx {
    private Jmx() {
    }

    public static void registerStandardMXBeans(Registry registry) {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            registry.register(new MemoryPoolMeter(registry, memoryPoolMXBean));
        }
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            registry.register(new BufferPoolMeter(registry, bufferPoolMXBean));
        }
    }

    public static void registerMappingsFromConfig(Registry registry, Config cfg) {
        registry.register(new JmxMeter(registry, JmxConfig.from(cfg)));
    }
}

