/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.util.HashMap;
import java.util.Map;
import spectator-agent.spectator.impl.AsciiSet;

final class Constants {
    static final int NO_MATCH = -1;
    static final AsciiSet LOWER = AsciiSet.fromPattern("a-z");
    static final AsciiSet UPPER = AsciiSet.fromPattern("A-Z");
    static final AsciiSet ASCII = AsciiSet.all();
    static final AsciiSet ALPHA = LOWER.union(UPPER);
    static final AsciiSet DIGIT = AsciiSet.fromPattern("0-9");
    static final AsciiSet ALNUM = ALPHA.union(DIGIT);
    static final AsciiSet PUNCT = AsciiSet.fromPattern("-!\"#$%&'()*+,./:;<=>?@[\\]^_`{|}~");
    static final AsciiSet GRAPH = PUNCT.union(ALNUM);
    static final AsciiSet PRINT = GRAPH.union(AsciiSet.fromPattern(" "));
    static final AsciiSet BLANK = AsciiSet.fromPattern(" \t");
    static final AsciiSet CNTRL = AsciiSet.control();
    static final AsciiSet XDIGIT = AsciiSet.fromPattern("0-9a-fA-F");
    static final AsciiSet WORD_CHARS = AsciiSet.fromPattern("a-zA-Z_0-9");
    static final AsciiSet SPACE = AsciiSet.fromPattern(" \t\n\u000b\f\r");
    static final Map<String, AsciiSet> NAMED_CHAR_CLASSES = new HashMap<String, AsciiSet>();

    private Constants() {
    }

    static {
        NAMED_CHAR_CLASSES.put("Lower", LOWER);
        NAMED_CHAR_CLASSES.put("Upper", UPPER);
        NAMED_CHAR_CLASSES.put("ASCII", ASCII);
        NAMED_CHAR_CLASSES.put("Alpha", ALPHA);
        NAMED_CHAR_CLASSES.put("Digit", DIGIT);
        NAMED_CHAR_CLASSES.put("Alnum", ALNUM);
        NAMED_CHAR_CLASSES.put("Punct", PUNCT);
        NAMED_CHAR_CLASSES.put("Graph", GRAPH);
        NAMED_CHAR_CLASSES.put("Print", PRINT);
        NAMED_CHAR_CLASSES.put("Blank", BLANK);
        NAMED_CHAR_CLASSES.put("Cntrl", CNTRL);
        NAMED_CHAR_CLASSES.put("XDigit", XDIGIT);
        NAMED_CHAR_CLASSES.put("Space", SPACE);
    }
}

