/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Meter;

abstract class AtlasMeter
implements Meter {
    protected final Id id;
    protected final Clock clock;
    private final long ttl;
    private volatile long lastUpdated;

    AtlasMeter(Id id, Clock clock, long ttl) {
        this.id = id;
        this.clock = clock;
        this.ttl = ttl;
        this.lastUpdated = clock.wallTime();
    }

    void updateLastModTime() {
        this.lastUpdated = this.clock.wallTime();
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return this.clock.wallTime() - this.lastUpdated > this.ttl;
    }
}

