/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.io.IOException;
import java.util.Map;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.core.JsonProcessingException;
import spectator-agent.json.jackson.databind.JsonSerializer;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.impl.AsciiSet;

public class MeasurementSerializer
extends JsonSerializer<Measurement> {
    private final AsciiSet set;
    private final Map<String, AsciiSet> overrides;

    public MeasurementSerializer(AsciiSet set, Map<String, AsciiSet> overrides) {
        this.set = set;
        this.overrides = overrides;
    }

    private String fixKey(String k) {
        return this.set.replaceNonMembers(k, '_');
    }

    private String fixValue(String k, String v) {
        AsciiSet s = this.overrides.getOrDefault(k, this.set);
        return s.replaceNonMembers(v, '_');
    }

    @Override
    public void serialize(Measurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        gen.writeStringField("name", this.fixValue("name", value.id().name()));
        boolean explicitDsType = false;
        for (Tag t : value.id().tags()) {
            if ("name".equals(t.key())) continue;
            if ("atlas.dstype".equals(t.key())) {
                explicitDsType = true;
            }
            String k = this.fixKey(t.key());
            String v = this.fixValue(k, t.value());
            gen.writeStringField(k, v);
        }
        if (!explicitDsType) {
            gen.writeStringField("atlas.dstype", "gauge");
        }
        gen.writeEndObject();
        gen.writeNumberField("timestamp", value.timestamp());
        gen.writeNumberField("value", value.value());
        gen.writeEndObject();
    }
}

