/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.atlas.impl.Subscription;
import spectator-agent.spectator.impl.Preconditions;

public final class Subscriptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Subscriptions.class);
    private List<Subscription> expressions = Collections.emptyList();

    public void update(Map<Subscription, Long> subs, long currentTime, long expirationTime) {
        for (Subscription sub : this.expressions) {
            if (subs.put(sub, expirationTime) != null) continue;
            LOGGER.info("new subscription: {}", (Object)sub);
        }
        Iterator<Map.Entry<Subscription, Long>> it = subs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Subscription, Long> entry = it.next();
            if (entry.getValue() >= currentTime) continue;
            LOGGER.info("expired: {}", (Object)entry.getKey());
            it.remove();
        }
    }

    public List<Subscription> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Subscription> expressions) {
        this.expressions = Preconditions.checkNotNull(expressions, "expressions");
    }

    public Subscriptions withExpressions(List<Subscription> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscriptions that = (Subscriptions)o;
        return this.expressions.equals(that.expressions);
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public String toString() {
        return "Subscriptions(" + this.expressions + ")";
    }
}

