/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class GaugePoller {
    private static final ThreadFactory FACTORY = new ThreadFactory(){
        private final AtomicInteger next = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            String name = "spectator-gauge-polling-" + this.next.getAndIncrement();
            Thread t = new Thread(r, name);
            t.setDaemon(true);
            return t;
        }
    };
    private static final ScheduledExecutorService DEFAULT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(FACTORY);

    static <T> void schedule(WeakReference<T> ref, long delay, Consumer<T> poll) {
        GaugePoller.schedule(DEFAULT_EXECUTOR, ref, delay, poll);
    }

    static <T> void schedule(ScheduledExecutorService executor, WeakReference<T> ref, long delay, Consumer<T> poll) {
        AtomicReference futureRef = new AtomicReference();
        Runnable cancel = () -> {
            Future f = (Future)futureRef.get();
            if (f != null) {
                f.cancel(false);
            }
        };
        Runnable task = () -> {
            try {
                Object r = ref.get();
                if (r != null) {
                    poll.accept(r);
                } else {
                    cancel.run();
                }
            }
            catch (Throwable t) {
                cancel.run();
            }
        };
        futureRef.set(executor.scheduleWithFixedDelay(task, delay, delay, TimeUnit.MILLISECONDS));
    }

    private GaugePoller() {
    }
}

