/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.Collections;
import java.util.Map;

public final class TagsValuePair {
    private final Map<String, String> tags;
    private final double value;

    public TagsValuePair(Map<String, String> tags, double value) {
        this.tags = Collections.unmodifiableMap(tags);
        this.value = value;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public double value() {
        return this.value;
    }

    public String toString() {
        return "TagsValuePair(" + this.tags + "," + this.value + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TagsValuePair)) {
            return false;
        }
        TagsValuePair other = (TagsValuePair)obj;
        return this.tags.equals(other.tags) && Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        int result = this.tags.hashCode();
        result = 31 * result + Double.hashCode(this.value);
        return result;
    }
}

