/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Utils;

public final class CardinalityLimiters {
    private static final long REFRESH_INTERVAL = 600000L;
    private static final int MAX_LIMIT = 100;
    public static final String OTHERS = "--others--";

    private CardinalityLimiters() {
    }

    public static Function<String, String> first(int n) {
        return new FirstLimiter(Math.min(n, 100));
    }

    public static Function<String, String> mostFrequent(int n) {
        return CardinalityLimiters.mostFrequent(n, Clock.SYSTEM);
    }

    static Function<String, String> mostFrequent(int n, Clock clock) {
        return new MostFrequentLimiter(Math.min(n, 100), clock);
    }

    private static class MostFrequentLimiter
    implements Function<String, String> {
        private final ReentrantLock lock = new ReentrantLock();
        private final ConcurrentHashMap<String, AtomicLong> values = new ConcurrentHashMap();
        private final int n;
        private final Clock clock;
        private volatile Function<String, String> limiter;
        private volatile long limiterTimestamp;
        private volatile long cutoff;

        MostFrequentLimiter(int n, Clock clock) {
            this.n = n;
            this.clock = clock;
            this.limiter = CardinalityLimiters.first(n);
            this.limiterTimestamp = clock.wallTime();
            this.cutoff = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void updateCutoff() {
            long now = this.clock.wallTime();
            if (now - this.limiterTimestamp > 600000L) {
                this.lock.lock();
                try {
                    if (now - this.limiterTimestamp > 600000L) {
                        this.limiterTimestamp = this.clock.wallTime();
                        long min = this.values.values().stream().map(AtomicLong::get).sorted((a, b) -> Long.compareUnsigned(b, a)).limit(this.n).min(Long::compareUnsigned).orElseGet(() -> 0L);
                        long dropCutoff = Math.max(min / 2L, 1L);
                        this.values.entrySet().removeIf(e -> ((AtomicLong)e.getValue()).get() <= dropCutoff);
                        this.values.values().forEach(v -> v.set(1L));
                        this.cutoff = 1L;
                        this.limiter = CardinalityLimiters.first(this.n);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public String apply(String s) {
            AtomicLong count = Utils.computeIfAbsent(this.values, s, k -> new AtomicLong(0L));
            long num = count.incrementAndGet();
            if (num >= this.cutoff) {
                this.updateCutoff();
                return this.limiter.apply(s);
            }
            return CardinalityLimiters.OTHERS;
        }

        public String toString() {
            String vs = this.values.entrySet().stream().filter(e -> ((AtomicLong)e.getValue()).get() >= this.cutoff).map(e -> "(" + (String)e.getKey() + "," + e.getValue() + ")").sorted().collect(Collectors.joining(","));
            return "MostFrequentLimiter(" + this.cutoff + "," + this.limiter + ",values=[" + vs + "])";
        }
    }

    private static class FirstLimiter
    implements Function<String, String> {
        private final ReentrantLock lock = new ReentrantLock();
        private final ConcurrentHashMap<String, String> values = new ConcurrentHashMap();
        private final AtomicInteger remaining;

        FirstLimiter(int n) {
            this.remaining = new AtomicInteger(n);
        }

        private void add(String s) {
            if (this.remaining.get() > 0) {
                this.lock.lock();
                try {
                    if (this.remaining.get() > 0) {
                        this.values.put(s, s);
                        this.remaining.decrementAndGet();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public String apply(String s) {
            if (this.remaining.get() <= 0) {
                return this.values.getOrDefault(s, CardinalityLimiters.OTHERS);
            }
            String v = this.values.get(s);
            if (v == null) {
                this.add(s);
                v = this.values.getOrDefault(s, CardinalityLimiters.OTHERS);
            }
            return v;
        }

        public String toString() {
            String vs = this.values.keySet().stream().sorted().collect(Collectors.joining(","));
            return "FirstLimiter(" + vs + ")";
        }
    }
}

