/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.histogram;

import java.util.Collections;
import java.util.function.LongFunction;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;

public final class BucketDistributionSummary
implements DistributionSummary {
    private final Registry registry;
    private final Id id;
    private final LongFunction<String> f;

    public static BucketDistributionSummary get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketDistributionSummary(registry, id, f);
    }

    BucketDistributionSummary(Registry registry, Id id, LongFunction<String> f) {
        this.registry = registry;
        this.id = id;
        this.f = f;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount) {
        this.distributionSummary(this.f.apply(amount)).record(amount);
    }

    DistributionSummary distributionSummary(String bucket) {
        return this.registry.distributionSummary(this.id.withTag("bucket", bucket));
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalAmount() {
        return 0L;
    }
}

