/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.atlas.AtlasRegistry;
import spectator-agent.spectator.atlas.MaxGauge;
import spectator-agent.spectator.impl.SwapMeter;

final class SwapMaxGauge
implements MaxGauge,
SwapMeter<MaxGauge> {
    private final AtlasRegistry registry;
    private final Id id;
    private volatile MaxGauge underlying;

    SwapMaxGauge(AtlasRegistry registry, Id id, MaxGauge underlying) {
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        MaxGauge g = this.underlying;
        return g == null || g.hasExpired();
    }

    @Override
    public void set(double value) {
        this.get().set(value);
    }

    @Override
    public double value() {
        return this.get().value();
    }

    @Override
    public void set(MaxGauge g) {
        this.underlying = g;
    }

    @Override
    public MaxGauge get() {
        MaxGauge g = this.underlying;
        if (g == null) {
            this.underlying = g = this.unwrap(this.registry.maxGauge(this.id));
        }
        return g;
    }

    private MaxGauge unwrap(MaxGauge g) {
        MaxGauge tmp = g;
        while (tmp instanceof SwapMaxGauge) {
            tmp = ((SwapMaxGauge)tmp).get();
        }
        return tmp;
    }
}

