/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.atlas.AtlasRegistry;
import spectator-agent.spectator.atlas.DoubleCounter;
import spectator-agent.spectator.impl.SwapMeter;

final class SwapDoubleCounter
implements DoubleCounter,
SwapMeter<DoubleCounter> {
    private final AtlasRegistry registry;
    private final Id id;
    private volatile DoubleCounter underlying;

    SwapDoubleCounter(AtlasRegistry registry, Id id, DoubleCounter underlying) {
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        DoubleCounter c = this.underlying;
        return c == null || c.hasExpired();
    }

    @Override
    public void add(double amount) {
        this.get().add(amount);
    }

    @Override
    public double actualCount() {
        return this.get().actualCount();
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public void set(DoubleCounter c) {
        this.underlying = c;
    }

    @Override
    public DoubleCounter get() {
        DoubleCounter c = this.underlying;
        if (c == null) {
            this.underlying = c = this.unwrap(this.registry.doubleCounter(this.id));
        }
        return c;
    }

    private DoubleCounter unwrap(DoubleCounter c) {
        DoubleCounter tmp = c;
        while (tmp instanceof SwapDoubleCounter) {
            tmp = ((SwapDoubleCounter)tmp).get();
        }
        return tmp;
    }
}

