/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DoubleCounter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepDouble;

class AtlasDoubleCounter
extends AtlasMeter
implements DoubleCounter {
    private final StepDouble value;
    private final Id stat;

    AtlasDoubleCounter(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = id.withTag(Statistic.count).withTags(id.tags()).withTag(DsType.rate);
    }

    @Override
    public Iterable<Measurement> measure() {
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.stat, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    @Override
    public void add(double amount) {
        this.value.getCurrent().addAndGet(amount);
        this.updateLastModTime();
    }

    @Override
    public double actualCount() {
        return this.value.poll();
    }

    @Override
    public void increment() {
        this.add(1.0);
    }

    @Override
    public void increment(long amount) {
        this.add(amount);
    }

    @Override
    public long count() {
        return (long)this.value.poll();
    }
}

