/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.impl.SwapMeter;

final class SwapTimer
implements Timer,
SwapMeter<Timer> {
    private final Registry registry;
    private final Id id;
    private volatile Timer underlying;

    SwapTimer(Registry registry, Id id, Timer underlying) {
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        Timer t = this.underlying;
        return t == null || t.hasExpired();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.get().record(amount, unit);
    }

    @Override
    public <T> T record(Callable<T> f) throws Exception {
        return this.get().record(f);
    }

    @Override
    public void record(Runnable f) {
        this.get().record(f);
    }

    @Override
    public long count() {
        return this.get().count();
    }

    @Override
    public long totalTime() {
        return this.get().totalTime();
    }

    @Override
    public void set(Timer t) {
        this.underlying = t;
    }

    @Override
    public Timer get() {
        Timer t = this.underlying;
        if (t == null) {
            this.underlying = t = this.unwrap(this.registry.timer(this.id));
        }
        return t;
    }

    private Timer unwrap(Timer t) {
        Timer tmp = t;
        while (tmp instanceof SwapTimer) {
            tmp = ((SwapTimer)tmp).get();
        }
        return tmp;
    }
}

