/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.impl.SwapMeter;

final class SwapCounter
implements Counter,
SwapMeter<Counter> {
    private final Registry registry;
    private final Id id;
    private volatile Counter underlying;

    SwapCounter(Registry registry, Id id, Counter underlying) {
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        Counter c = this.underlying;
        return c == null || c.hasExpired();
    }

    @Override
    public void increment() {
        this.get().increment();
    }

    @Override
    public void increment(long amount) {
        this.get().increment(amount);
    }

    @Override
    public long count() {
        return this.get().count();
    }

    @Override
    public void set(Counter c) {
        this.underlying = c;
    }

    @Override
    public Counter get() {
        Counter c = this.underlying;
        if (c == null) {
            this.underlying = c = this.unwrap(this.registry.counter(this.id));
        }
        return c;
    }

    private Counter unwrap(Counter c) {
        Counter tmp = c;
        while (tmp instanceof SwapCounter) {
            tmp = ((SwapCounter)tmp).get();
        }
        return tmp;
    }
}

