/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DefaultId;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.NoopCounter;
import spectator-agent.spectator.api.NoopDistributionSummary;
import spectator-agent.spectator.api.NoopGauge;
import spectator-agent.spectator.api.NoopTimer;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.RegistryConfig;
import spectator-agent.spectator.api.SwapCounter;
import spectator-agent.spectator.api.SwapDistributionSummary;
import spectator-agent.spectator.api.SwapGauge;
import spectator-agent.spectator.api.SwapTimer;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.api.Utils;
import spectator-agent.spectator.api.patterns.PolledMeter;
import spectator-agent.spectator.impl.Config;
import spectator-agent.spectator.impl.Preconditions;
import spectator-agent.spectator.impl.SwapMeter;

public abstract class AbstractRegistry
implements Registry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Clock clock;
    private final RegistryConfig config;
    private final ConcurrentHashMap<Id, Meter> meters;
    private final ConcurrentHashMap<Id, Object> state;

    public AbstractRegistry(Clock clock) {
        this(clock, Config.defaultConfig());
    }

    public AbstractRegistry(Clock clock, RegistryConfig config) {
        this.clock = clock;
        this.config = config;
        this.meters = new ConcurrentHashMap();
        this.state = new ConcurrentHashMap();
    }

    protected abstract Counter newCounter(Id var1);

    private Counter createCounter(Id id) {
        return new SwapCounter(this, id, this.newCounter(id));
    }

    protected abstract DistributionSummary newDistributionSummary(Id var1);

    private DistributionSummary createDistributionSummary(Id id) {
        return new SwapDistributionSummary(this, id, this.newDistributionSummary(id));
    }

    protected abstract Timer newTimer(Id var1);

    private Timer createTimer(Id id) {
        return new SwapTimer(this, id, this.newTimer(id));
    }

    protected abstract Gauge newGauge(Id var1);

    private Gauge createGauge(Id id) {
        return new SwapGauge(this, id, this.newGauge(id));
    }

    @Override
    public final Clock clock() {
        return this.clock;
    }

    @Override
    public final RegistryConfig config() {
        return this.config;
    }

    @Override
    public final Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public final Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    private void logTypeError(Id id, Class<?> desired, Class<?> found) {
        String dtype = desired.getName();
        String ftype = found.getName();
        String msg = String.format("cannot access '%s' as a %s, it already exists as a %s", id, dtype, ftype);
        this.propagate(new IllegalStateException(msg));
    }

    private Meter compute(Meter m, Meter fallback) {
        return this.meters.size() >= this.config.maxNumberOfMeters() ? fallback : m;
    }

    @Override
    public void register(Meter meter) {
        PolledMeter.monitorMeter(this, meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    @Override
    public final Counter counter(Id id) {
        return this.getOrCreate(id, Counter.class, NoopCounter.INSTANCE, this::createCounter);
    }

    @Override
    public final DistributionSummary distributionSummary(Id id) {
        return this.getOrCreate(id, DistributionSummary.class, NoopDistributionSummary.INSTANCE, this::createDistributionSummary);
    }

    @Override
    public final Timer timer(Id id) {
        return this.getOrCreate(id, Timer.class, NoopTimer.INSTANCE, this::createTimer);
    }

    @Override
    public final Gauge gauge(Id id) {
        return this.getOrCreate(id, Gauge.class, NoopGauge.INSTANCE, this::createGauge);
    }

    protected <T extends Meter> T getOrCreate(Id id, Class<T> cls, T dflt, Function<Id, T> factory) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = Utils.computeIfAbsent(this.meters, id, i -> this.compute((Meter)factory.apply((Id)i), dflt));
            if (!cls.isAssignableFrom(m.getClass())) {
                this.logTypeError(id, cls, m.getClass());
                m = dflt;
            }
            return (T)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return dflt;
        }
    }

    @Override
    public final Meter get(Id id) {
        return this.meters.get(id);
    }

    @Override
    public final Iterator<Meter> iterator() {
        PolledMeter.update(this);
        return this.meters.values().iterator();
    }

    protected void removeExpiredMeters() {
        Iterator<Map.Entry<Id, Meter>> it = this.meters.entrySet().iterator();
        while (it.hasNext()) {
            SwapMeter swappable;
            Map.Entry<Id, Meter> entry = it.next();
            Meter m = entry.getValue();
            if (!(m instanceof SwapMeter) || !(swappable = (SwapMeter)m).get().hasExpired()) continue;
            swappable.set(null);
            it.remove();
        }
    }
}

