/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.atlas.MaxGauge;
import spectator-agent.spectator.impl.AtomicDouble;
import spectator-agent.spectator.impl.StepDouble;

class AtlasMaxGauge
extends AtlasMeter
implements MaxGauge {
    private final StepDouble value;
    private final Id stat;

    AtlasMaxGauge(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = id.withTag(Statistic.max).withTags(id.tags()).withTag(DsType.gauge);
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.stat, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    @Override
    public void set(double v) {
        AtomicDouble current = this.value.getCurrent();
        double max = current.get();
        while (v > max && !current.compareAndSet(max, v)) {
            max = current.get();
        }
        this.updateLastModTime();
    }

    @Override
    public double value() {
        return this.value.poll();
    }
}

