/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Utils;
import spectator-agent.spectator.api.patterns.GaugePoller;
import spectator-agent.spectator.api.patterns.IdBuilder;
import spectator-agent.spectator.api.patterns.TagsBuilder;

public final class PolledMeter {
    private PolledMeter() {
    }

    public static IdBuilder<Builder> using(Registry registry) {
        return new IdBuilder<Builder>(registry){

            @Override
            protected Builder createTypeBuilder(Id id) {
                return new Builder(this.registry, id);
            }
        };
    }

    public static void update(Registry registry) {
        Iterator iter = registry.state().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof AbstractMeterState)) continue;
            AbstractMeterState tuple = (AbstractMeterState)entry.getValue();
            tuple.doUpdate(registry);
            if (!tuple.hasExpired()) continue;
            iter.remove();
        }
    }

    public static void remove(Registry registry, Id id) {
        Object obj = registry.state().get(id);
        if (obj instanceof AbstractMeterState) {
            registry.state().remove(id, obj);
        }
    }

    @Deprecated
    public static void monitorMeter(Registry registry, Meter meter) {
        ConcurrentMap<Id, Object> state = registry.state();
        Object c = Utils.computeIfAbsent(state, meter.id(), MeterState::new);
        if (!(c instanceof MeterState)) {
            Utils.propagateTypeError(registry, meter.id(), MeterState.class, c.getClass());
        } else {
            MeterState t = (MeterState)c;
            t.add(meter);
            t.schedule(registry, null);
        }
    }

    static final class CounterEntry<T> {
        private final WeakReference<T> ref;
        private final ToLongFunction<T> f;
        private long previous;

        CounterEntry(T obj, ToLongFunction<T> f) {
            this.ref = new WeakReference<T>(obj);
            this.f = f;
            this.previous = f.applyAsLong(obj);
        }

        private void update(Counter counter) {
            Object obj = this.ref.get();
            if (obj != null) {
                long current = this.f.applyAsLong(obj);
                if (current > this.previous) {
                    counter.increment(current - this.previous);
                }
                this.previous = current;
            }
        }
    }

    static final class CounterState<T>
    extends AbstractMeterState {
        private final Counter counter;
        private final ConcurrentLinkedQueue<CounterEntry<T>> entries;

        CounterState(Counter counter) {
            this.counter = counter;
            this.entries = new ConcurrentLinkedQueue();
        }

        private void add(T obj, ToLongFunction<T> f) {
            this.entries.add(new CounterEntry<T>(obj, f));
        }

        @Override
        protected Id id() {
            return this.counter.id();
        }

        @Override
        protected boolean hasExpired() {
            return this.entries.isEmpty();
        }

        @Override
        protected void update(Registry registry) {
            Iterator<CounterEntry<T>> iter = this.entries.iterator();
            while (iter.hasNext()) {
                CounterEntry<T> state = iter.next();
                if (((CounterEntry)state).ref.get() == null) {
                    iter.remove();
                    continue;
                }
                ((CounterEntry)state).update(this.counter);
            }
        }
    }

    static final class MeterState
    extends AbstractMeterState {
        private final Id id;
        private final ConcurrentLinkedQueue<Meter> queue;

        MeterState(Id id) {
            this.id = id;
            this.queue = new ConcurrentLinkedQueue();
        }

        void add(Meter m) {
            this.queue.add(m);
        }

        @Override
        protected Id id() {
            return this.id;
        }

        @Override
        protected boolean hasExpired() {
            return this.queue.isEmpty();
        }

        private Iterable<Measurement> measure() {
            HashMap<Id, Measurement> measurements = new HashMap<Id, Measurement>();
            Iterator<Meter> iter = this.queue.iterator();
            while (iter.hasNext()) {
                Meter meter = iter.next();
                if (meter.hasExpired()) {
                    iter.remove();
                    continue;
                }
                for (Measurement m : meter.measure()) {
                    Measurement prev = (Measurement)measurements.get(m.id());
                    if (prev == null) {
                        measurements.put(m.id(), m);
                        continue;
                    }
                    double v = prev.value() + m.value();
                    measurements.put(prev.id(), new Measurement(prev.id(), prev.timestamp(), v));
                }
            }
            return measurements.values();
        }

        @Override
        protected void update(Registry registry) {
            for (Measurement m : this.measure()) {
                registry.gauge(m.id()).set(m.value());
            }
        }
    }

    static final class ValueEntry<T> {
        private final WeakReference<T> ref;
        private final ToDoubleFunction<T> f;

        ValueEntry(T obj, ToDoubleFunction<T> f) {
            this.ref = new WeakReference<T>(obj);
            this.f = f;
        }
    }

    static final class ValueState<T>
    extends AbstractMeterState {
        private final Gauge gauge;
        private final ConcurrentLinkedQueue<ValueEntry<T>> pairs;

        ValueState(Gauge gauge) {
            this.gauge = gauge;
            this.pairs = new ConcurrentLinkedQueue();
        }

        private void add(T obj, ToDoubleFunction<T> f) {
            this.pairs.add(new ValueEntry<T>(obj, f));
        }

        @Override
        protected Id id() {
            return this.gauge.id();
        }

        @Override
        protected boolean hasExpired() {
            return this.pairs.isEmpty();
        }

        @Override
        protected void update(Registry registry) {
            double sum = Double.NaN;
            Iterator<ValueEntry<T>> iter = this.pairs.iterator();
            while (iter.hasNext()) {
                ValueEntry<T> pair = iter.next();
                Object obj = ((ValueEntry)pair).ref.get();
                if (obj != null) {
                    double v = ((ValueEntry)pair).f.applyAsDouble(obj);
                    if (Double.isNaN(v)) continue;
                    sum = Double.isNaN(sum) ? v : sum + v;
                    continue;
                }
                iter.remove();
            }
            this.gauge.set(sum);
        }
    }

    static abstract class AbstractMeterState {
        private boolean scheduled = false;

        AbstractMeterState() {
        }

        protected abstract Id id();

        protected abstract boolean hasExpired();

        protected abstract void update(Registry var1);

        void doUpdate(Registry registry) {
            if (this.hasExpired()) {
                registry.state().remove(this.id());
            } else {
                this.update(registry);
            }
        }

        void schedule(Registry registry, ScheduledExecutorService executor) {
            if (!this.scheduled) {
                long delay = registry.config().gaugePollingFrequency().toMillis();
                WeakReference<AbstractMeterState> tupleRef = new WeakReference<AbstractMeterState>(this);
                if (executor == null) {
                    GaugePoller.schedule(tupleRef, delay, t -> t.update(registry));
                } else {
                    GaugePoller.schedule(executor, tupleRef, delay, t -> t.update(registry));
                }
                this.scheduled = true;
            }
        }
    }

    public static final class Builder
    extends TagsBuilder<Builder> {
        private final Registry registry;
        private final Id baseId;
        private ScheduledExecutorService executor;

        Builder(Registry registry, Id baseId) {
            this.registry = registry;
            this.baseId = baseId;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public <T extends Number> T monitorValue(T number) {
            return (T)this.monitorValue(number, Number::doubleValue);
        }

        public <T> T monitorValue(T obj, ToDoubleFunction<T> f) {
            Id id = this.baseId.withTags(this.extraTags);
            Gauge gauge = this.registry.gauge(id);
            ValueState tuple = new ValueState(gauge);
            ConcurrentMap<Id, Object> state = this.registry.state();
            Object c = Utils.computeIfAbsent(state, id, i -> tuple);
            if (!(c instanceof ValueState)) {
                Utils.propagateTypeError(this.registry, id, PolledMeter.class, c.getClass());
            } else {
                ValueState t = (ValueState)c;
                t.add(obj, f);
                t.schedule(this.registry, this.executor);
            }
            return obj;
        }

        public <T extends Number> T monitorMonotonicCounter(T number) {
            return (T)this.monitorMonotonicCounter(number, Number::longValue);
        }

        public <T> T monitorMonotonicCounter(T obj, ToLongFunction<T> f) {
            Id id = this.baseId.withTags(this.extraTags);
            Counter counter = this.registry.counter(id);
            CounterState tuple = new CounterState(counter);
            ConcurrentMap<Id, Object> state = this.registry.state();
            Object c = Utils.computeIfAbsent(state, id, i -> tuple);
            if (!(c instanceof CounterState)) {
                Utils.propagateTypeError(this.registry, id, PolledMeter.class, c.getClass());
            } else {
                CounterState t = (CounterState)c;
                t.add(obj, f);
                t.schedule(this.registry, this.executor);
            }
            return obj;
        }

        public <T extends Collection<?>> T monitorSize(T collection) {
            return (T)this.monitorValue(collection, Collection::size);
        }

        public <T extends Map<?, ?>> T monitorSize(T map) {
            return (T)this.monitorValue(map, Map::size);
        }
    }
}

