/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.List;
import java.util.Map;

public final class EvalPayload {
    private final long timestamp;
    private final List<Metric> metrics;

    public EvalPayload(long timestamp, List<Metric> metrics) {
        this.timestamp = timestamp;
        this.metrics = metrics;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalPayload payload = (EvalPayload)o;
        return this.timestamp == payload.timestamp && this.metrics.equals(payload.metrics);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.metrics.hashCode();
        return result;
    }

    public String toString() {
        return "EvalPayload(timestamp=" + this.timestamp + ", metrics=" + this.metrics + ")";
    }

    public static final class Metric {
        private final String id;
        private final Map<String, String> tags;
        private final double value;

        public Metric(String id, Map<String, String> tags, double value) {
            this.id = id;
            this.tags = tags;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public double getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metric metric = (Metric)o;
            return Double.compare(metric.value, this.value) == 0 && this.id.equals(metric.id) && this.tags.equals(metric.tags);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.tags.hashCode();
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return "Metric(id=" + this.id + ", tags=" + this.tags + ", value=" + this.value + ")";
        }
    }
}

