/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepLong;

class AtlasCounter
extends AtlasMeter
implements Counter {
    private final StepLong value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepLong(0L, clock, step);
        this.stat = id.withTag(Statistic.count).withTags(id.tags()).withTag(DsType.rate);
    }

    @Override
    public Iterable<Measurement> measure() {
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.stat, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    @Override
    public void increment() {
        this.value.getCurrent().incrementAndGet();
        this.updateLastModTime();
    }

    @Override
    public void increment(long amount) {
        this.value.getCurrent().addAndGet(amount);
        this.updateLastModTime();
    }

    @Override
    public long count() {
        return this.value.poll();
    }
}

