/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.agent;

import com.netflix.spectator.agent.JmxConfig;
import com.netflix.spectator.agent.JmxMeter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Agent.class);

    private Agent() {
    }

    private static Config loadConfig(String userResources) {
        Config config = ConfigFactory.load((String)"agent");
        if (userResources != null && !"".equals(userResources)) {
            for (String userResource : userResources.split("[,\\s]+]")) {
                if (userResource.startsWith("file:")) {
                    File file = new File(userResource.substring("file:".length()));
                    LOGGER.info("loading configuration from file: {}", (Object)file);
                    Config user = ConfigFactory.parseFile((File)file).resolve();
                    config = user.withFallback((ConfigMergeable)config);
                    continue;
                }
                LOGGER.info("loading configuration from resource: {}", (Object)userResource);
                Config user = ConfigFactory.load((String)userResource);
                config = user.withFallback((ConfigMergeable)config);
            }
        }
        return config.getConfig("netflix.spectator.agent");
    }

    private static void createDependencyProperties(Config config) {
        if (config.hasPath("dependencies")) {
            List deps = config.getStringList("dependencies");
            for (int i = 0; i < deps.size(); ++i) {
                String prop = String.format("netflix.spectator.agent.dependency.%03d", i);
                System.setProperty(prop, (String)deps.get(i));
            }
        }
    }

    public static void premain(String arg, Instrumentation instrumentation) throws Exception {
        Config config = Agent.loadConfig(arg);
        Agent.createDependencyProperties(config);
        AtlasRegistry registry = new AtlasRegistry(Clock.SYSTEM, (AtlasConfig)new AgentAtlasConfig(config));
        Spectator.globalRegistry().add((Registry)registry);
        GcLogger gcLogger = new GcLogger();
        if (config.getBoolean("collection.gc")) {
            gcLogger.start(null);
        }
        if (config.getBoolean("collection.jvm")) {
            Jmx.registerStandardMXBeans((Registry)registry);
        }
        if (config.getBoolean("collection.jmx")) {
            for (Config cfg : config.getConfigList("jmx.mappings")) {
                registry.register((Meter)new JmxMeter((Registry)registry, JmxConfig.from(cfg)));
            }
        }
        registry.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((AtlasRegistry)registry).stop(), "spectator-agent-shutdown"));
    }

    private static class AgentAtlasConfig
    implements AtlasConfig {
        private final Config config;

        AgentAtlasConfig(Config config) {
            this.config = config;
        }

        public String get(String k) {
            return this.config.hasPath(k) ? this.config.getString(k) : null;
        }

        public Map<String, String> commonTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            for (Config cfg : this.config.getConfigList("atlas.tags")) {
                String value = cfg.getString("value");
                if (value.isEmpty()) continue;
                tags.put(cfg.getString("key"), cfg.getString("value"));
            }
            return tags;
        }
    }
}

