/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.deser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import spectator-agent.json.jackson.core.JsonParser;
import spectator-agent.json.jackson.databind.DeserializationContext;
import spectator-agent.json.jackson.databind.deser.std.StdScalarDeserializer;
import spectator-agent.json.jackson.databind.util.ByteBufferBackedOutputStream;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

