/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

public final class ValidCharacters {
    private static final boolean[] CHARS_ALLOWED;

    private ValidCharacters() {
    }

    public static String toValidCharset(String str) {
        int n = str.length();
        StringBuilder buf = new StringBuilder(n + 1);
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c < CHARS_ALLOWED.length && CHARS_ALLOWED[c]) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    static {
        int ch;
        CHARS_ALLOWED = new boolean[128];
        ValidCharacters.CHARS_ALLOWED[46] = true;
        ValidCharacters.CHARS_ALLOWED[45] = true;
        ValidCharacters.CHARS_ALLOWED[95] = true;
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            ValidCharacters.CHARS_ALLOWED[ch] = true;
        }
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            ValidCharacters.CHARS_ALLOWED[ch] = true;
        }
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            ValidCharacters.CHARS_ALLOWED[ch] = true;
        }
    }
}

