/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.io.IOException;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.core.JsonProcessingException;
import spectator-agent.json.jackson.databind.JsonSerializer;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.atlas.ValidCharacters;

class MeasurementSerializer
extends JsonSerializer<Measurement> {
    MeasurementSerializer() {
    }

    @Override
    public void serialize(Measurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        gen.writeStringField("name", ValidCharacters.toValidCharset(value.id().name()));
        boolean explicitDsType = false;
        for (Tag t : value.id().tags()) {
            if ("atlas.dstype".equals(t.key())) {
                explicitDsType = true;
            }
            String k = ValidCharacters.toValidCharset(t.key());
            String v = ValidCharacters.toValidCharset(t.value());
            gen.writeStringField(k, v);
        }
        if (!explicitDsType) {
            gen.writeStringField("atlas.dstype", "gauge");
        }
        gen.writeEndObject();
        gen.writeNumberField("timestamp", value.timestamp());
        gen.writeNumberField("value", value.value());
        gen.writeEndObject();
    }
}

