/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.sandbox;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.slf4j.Marker;
import spectator-agent.slf4j.MarkerFactory;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Spectator;
import spectator-agent.spectator.sandbox.BucketFunction;
import spectator-agent.spectator.sandbox.BucketFunctions;
import spectator-agent.spectator.sandbox.BucketTimer;

public class HttpLogEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpLogEntry.class);
    private static final Marker CLIENT = MarkerFactory.getMarker("http-client");
    private static final Marker SERVER = MarkerFactory.getMarker("http-server");
    private static final Registry REGISTRY = Spectator.globalRegistry();
    private static final Id COMPLETE = REGISTRY.createId("http.req.complete");
    private static final Id ATTEMPT = REGISTRY.createId("http.req.attempt");
    private static final Id REQ_HEADER_SIZE = REGISTRY.createId("http.req.headerSize");
    private static final Id REQ_ENTITY_SIZE = REGISTRY.createId("http.req.entitySize");
    private static final Id RES_HEADER_SIZE = REGISTRY.createId("http.res.headerSize");
    private static final Id RES_ENTITY_SIZE = REGISTRY.createId("http.res.entitySize");
    private static final BucketFunction BUCKETS = BucketFunctions.latency(HttpLogEntry.maxLatency(), TimeUnit.MILLISECONDS);
    private static final List<String> ENDPOINT_PREFIXES = HttpLogEntry.parseEndpoints(HttpLogEntry.endpointPrefixes());
    private final SimpleDateFormat isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private String clientName = null;
    private String requestId = HttpLogEntry.newId();
    private URI originalUri = null;
    private URI requestUri = null;
    private String method = null;
    private List<Header> requestHeaders = new ArrayList<Header>();
    private long requestContentLength = -1L;
    private String remoteAddr = null;
    private int remotePort = -1;
    private String attemptId = this.requestId;
    private int attempt = 1;
    private int maxAttempts = -1;
    private boolean canRetry = false;
    private int redirect = 0;
    private Throwable exception = null;
    private int statusCode = -1;
    private String statusReason = null;
    private List<Header> responseHeaders = new ArrayList<Header>();
    private long responseContentLength = -1L;
    private List<Event> events = new ArrayList<Event>();
    private long latency = -1L;
    private long originalStart = -1L;

    private static long maxLatency() {
        return Long.parseLong(System.getProperty("spectator.http.maxLatency", "8000"));
    }

    private static String endpointPrefixes() {
        return System.getProperty("spectator.http.endpointPrefixes", "/healthcheck");
    }

    private static List<String> parseEndpoints(String s) {
        String[] prefixes = s == null ? new String[]{} : s.split("[,\\s]+");
        ArrayList<String> buf = new ArrayList<String>();
        for (String prefix : prefixes) {
            String tmp = prefix.trim();
            if (tmp.length() <= 0) continue;
            buf.add(prefix);
        }
        Collections.sort(buf);
        return buf;
    }

    private static String longestPrefixMatch(String path, String dflt) {
        if (path == null || path.length() == 0) {
            return dflt;
        }
        int length = 0;
        String longest = null;
        for (String prefix : ENDPOINT_PREFIXES) {
            if (!path.startsWith(prefix) || prefix.length() <= length) continue;
            longest = prefix;
            length = prefix.length();
        }
        return longest == null ? dflt : longest;
    }

    public static void logClientRequest(HttpLogEntry entry) {
        HttpLogEntry.log(LOGGER, CLIENT, entry);
    }

    @Deprecated
    public static void logClientRequest(Logger logger, HttpLogEntry entry) {
        HttpLogEntry.log(logger, CLIENT, entry);
    }

    public static void logServerRequest(HttpLogEntry entry) {
        HttpLogEntry.log(LOGGER, SERVER, entry);
    }

    @Deprecated
    public static void logServerRequest(Logger logger, HttpLogEntry entry) {
        HttpLogEntry.log(logger, SERVER, entry);
    }

    private static void log(Logger logger, Marker marker, HttpLogEntry entry) {
        Id dimensions = REGISTRY.createId("tags").withTag("mode", marker.getName()).withTag("status", entry.getStatusTag()).withTag("statusCode", entry.getStatusCodeTag()).withTag("method", entry.method);
        if (entry.clientName != null) {
            dimensions = dimensions.withTag("client", entry.clientName);
        }
        if (marker == SERVER && entry.requestUri != null) {
            String path = entry.requestUri.getPath();
            dimensions = dimensions.withTag("endpoint", HttpLogEntry.longestPrefixMatch(path, "other"));
        }
        if (!entry.canRetry || entry.attempt >= entry.maxAttempts) {
            BucketTimer.get(REGISTRY, COMPLETE.withTags(dimensions.tags()), BUCKETS).record(entry.getOverallLatency(), TimeUnit.MILLISECONDS);
        }
        BucketTimer.get(REGISTRY, ATTEMPT.withTags(dimensions.tags()), BUCKETS).record(entry.getLatency(), TimeUnit.MILLISECONDS);
        REGISTRY.distributionSummary(REQ_HEADER_SIZE.withTags(dimensions.tags())).record(entry.getRequestHeadersLength());
        REGISTRY.distributionSummary(REQ_ENTITY_SIZE.withTags(dimensions.tags())).record(entry.requestContentLength);
        REGISTRY.distributionSummary(RES_HEADER_SIZE.withTags(dimensions.tags())).record(entry.getResponseHeadersLength());
        REGISTRY.distributionSummary(RES_ENTITY_SIZE.withTags(dimensions.tags())).record(entry.responseContentLength);
        if (logger.isDebugEnabled(marker)) {
            logger.debug(marker, entry.toString());
        }
    }

    private static String newId() {
        return UUID.randomUUID().toString();
    }

    private void reset(int redir) {
        if (this.originalStart < 0L && !this.events.isEmpty()) {
            this.originalStart = this.events.get(0).timestamp();
        }
        this.requestHeaders.clear();
        this.requestContentLength = -1L;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.redirect = redir;
        this.exception = null;
        this.statusCode = -1;
        this.responseHeaders.clear();
        this.responseContentLength = -1L;
        this.events.clear();
        this.latency = -1L;
    }

    public HttpLogEntry withClientName(String name) {
        this.clientName = name;
        return this;
    }

    public HttpLogEntry withOriginalUri(URI uri) {
        this.originalUri = uri;
        return this;
    }

    public HttpLogEntry withRequestUri(URI uri) {
        this.requestUri = uri;
        return this;
    }

    public HttpLogEntry withMethod(String httpMethod) {
        this.method = httpMethod;
        return this;
    }

    public HttpLogEntry withRequestHeader(String name, String value) {
        this.requestHeaders.add(new Header(name, value));
        return this;
    }

    public HttpLogEntry withRequestContentLength(long size) {
        this.requestContentLength = size;
        return this;
    }

    public HttpLogEntry withRemoteAddr(String addr) {
        this.remoteAddr = addr;
        return this;
    }

    public HttpLogEntry withRemotePort(int port) {
        this.remotePort = port;
        return this;
    }

    public HttpLogEntry withAttempt(int n) {
        this.attempt = n;
        this.attemptId = HttpLogEntry.newId();
        this.reset(0);
        return this;
    }

    public HttpLogEntry withRedirect(URI loc) {
        this.reset(this.redirect + 1);
        return this.withRequestUri(loc);
    }

    public HttpLogEntry withMaxAttempts(int attempts) {
        this.maxAttempts = attempts;
        return this;
    }

    public HttpLogEntry withCanRetry(boolean retry) {
        this.canRetry = retry;
        return this;
    }

    public HttpLogEntry withException(Throwable t) {
        this.exception = t;
        return this;
    }

    public HttpLogEntry withStatusCode(int code) {
        this.statusCode = code;
        return this;
    }

    public HttpLogEntry withStatusReason(String reason) {
        this.statusReason = reason;
        return this;
    }

    public HttpLogEntry withResponseHeader(String name, String value) {
        this.responseHeaders.add(new Header(name, value));
        return this;
    }

    public HttpLogEntry withResponseContentLength(long size) {
        this.responseContentLength = size;
        return this;
    }

    public HttpLogEntry withRequestLatency(long t) {
        this.latency = t;
        return this;
    }

    public HttpLogEntry mark(String name) {
        this.events.add(new Event(name, System.currentTimeMillis()));
        return this;
    }

    public HttpLogEntry mark(String name, long timestamp) {
        this.events.add(new Event(name, timestamp));
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public long getLatency() {
        if (this.latency >= 0L) {
            return this.latency;
        }
        if (this.events.size() >= 2) {
            return this.events.get(this.events.size() - 1).timestamp() - this.events.get(0).timestamp();
        }
        return -1L;
    }

    public long getOverallLatency() {
        if (this.maxAttempts <= 1 || this.originalStart < 0L) {
            return this.getLatency();
        }
        if (this.events.isEmpty()) {
            return -1L;
        }
        return this.events.get(this.events.size() - 1).timestamp() - this.originalStart;
    }

    public String getStartTime() {
        return this.events.isEmpty() ? "unknown" : this.isoDate.format(new Date(this.events.get(0).timestamp()));
    }

    private int getHeadersLength(List<Header> headers) {
        int size = 0;
        for (Header h : headers) {
            size += h.numBytes();
        }
        return size;
    }

    public int getRequestHeadersLength() {
        return this.getHeadersLength(this.requestHeaders);
    }

    public int getResponseHeadersLength() {
        return this.getHeadersLength(this.responseHeaders);
    }

    public String getTimeline() {
        StringBuilder builder = new StringBuilder();
        for (Event event : this.events) {
            builder.append(event.name()).append(":").append(event.timestamp()).append(";");
        }
        return builder.toString();
    }

    private String getExceptionClass() {
        return this.exception == null ? "null" : this.exception.getClass().getName();
    }

    private String getExceptionMessage() {
        return this.exception == null ? "null" : this.exception.getMessage();
    }

    private String getHeaders(List<Header> headers) {
        StringBuilder builder = new StringBuilder();
        for (Header h : headers) {
            builder.append(h.name()).append(':').append(h.value()).append(';');
        }
        return builder.toString();
    }

    public String getRequestHeaders() {
        return this.getHeaders(this.requestHeaders);
    }

    public String getResponseHeaders() {
        return this.getHeaders(this.responseHeaders);
    }

    private String getStatusTag() {
        return this.exception != null ? this.exception.getClass().getSimpleName() : (this.statusCode >= 100 ? this.statusCode / 100 + "xx" : "unknown");
    }

    private String getStatusCodeTag() {
        return this.exception != null ? this.exception.getClass().getSimpleName() : (this.statusCode >= 100 ? "" + this.statusCode : "unknown");
    }

    public String toString() {
        return this.clientName + '\t' + this.getStartTime() + '\t' + this.getLatency() + '\t' + this.getOverallLatency() + '\t' + this.getTimeline() + '\t' + this.method + '\t' + this.originalUri + '\t' + this.requestUri + '\t' + this.remoteAddr + '\t' + this.remotePort + '\t' + this.statusCode + '\t' + this.statusReason + '\t' + this.getExceptionClass() + '\t' + this.getExceptionMessage() + '\t' + this.getRequestHeadersLength() + '\t' + this.requestContentLength + '\t' + this.getResponseHeadersLength() + '\t' + this.responseContentLength + '\t' + this.getRequestHeaders() + '\t' + this.getResponseHeaders() + '\t' + this.redirect + '\t' + this.attempt + '\t' + this.maxAttempts;
    }

    private static class Event {
        private final String name;
        private final long timestamp;

        Event(String name, long timestamp) {
            this.name = name;
            this.timestamp = timestamp;
        }

        String name() {
            return this.name;
        }

        long timestamp() {
            return this.timestamp;
        }
    }

    private static class Header {
        private final String name;
        private final String value;

        Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String name() {
            return this.name;
        }

        String value() {
            return this.value;
        }

        int numBytes() {
            return this.name.length() + ": ".length() + this.value.length() + "\n".length();
        }
    }
}

